/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository;

import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeaterEntry;
import org.ametys.plugins.forms.repository.AbstractFormCopyUpdater;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.forms.repository.type.Rule;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;

public class FormQuestionRuleCopyUpdater
extends AbstractFormCopyUpdater {
    @Override
    public void updateForm(Form originalForm, Form createdForm) {
        boolean hasChanges = false;
        for (FormQuestion originalFormQuestion : originalForm.getQuestions()) {
            FormQuestion copiedQuestion;
            hasChanges = this._updateFormQuestionsRules(createdForm, originalFormQuestion, copiedQuestion = this._getCopiedQuestion(createdForm, originalFormQuestion)) || hasChanges;
        }
        if (hasChanges) {
            createdForm.saveChanges();
        }
    }

    private boolean _updateFormQuestionsRules(Form createdForm, FormQuestion originalQuestion, FormQuestion copiedQuestion) {
        ModifiableIndexableRepeater originalRulesRepeater = originalQuestion.getRepeater("rules");
        if (originalRulesRepeater != null) {
            ModifiableIndexableRepeater newRepeater = copiedQuestion.getRepeater("rules", true);
            for (ModifiableModelAwareRepeaterEntry repeaterEntry : originalRulesRepeater.getEntries()) {
                Rule rule = (Rule)repeaterEntry.getValue("rule");
                String oldSourceId = rule.getSourceId();
                FormQuestion originalSourceQuestion = (FormQuestion)this._resolver.resolveById(oldSourceId);
                FormQuestion copiedSourceQuestion = this._getCopiedQuestion(createdForm, originalSourceQuestion);
                rule.setSourceId(copiedSourceQuestion.getId());
                ModifiableIndexableRepeaterEntry newEntry = newRepeater.addEntry();
                newEntry.setValue("rule", (Object)rule);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateFormPage(FormPage originalFormPage, FormPage createdFormPage) {
    }

    @Override
    public void updateFormQuestion(FormQuestion originalFormQuestion, FormQuestion createdFormQuestion) {
        if (this._updateFormQuestionsRules(createdFormQuestion.getForm(), originalFormQuestion, createdFormQuestion)) {
            createdFormQuestion.getFormPage().saveChanges();
        }
    }
}

