/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.schedulable;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.schedule.AbstractSendingMailSchedulable;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class ExportXlsSchedulable
extends AbstractSendingMailSchedulable {
    public static final String FORM_EXPORT_XLS_DIR_NAME = "forms/export";
    public static final String PARAM_FORM_ID = "formId";
    protected SourceResolver _sourceResolver;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    protected void _doExecute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        File xslExportDirectory = new File(AmetysHomeHelper.getAmetysHomeData(), FORM_EXPORT_XLS_DIR_NAME);
        FileUtils.forceMkdir((File)xslExportDirectory);
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String formId = jobDataMap.getString("parameterValues#formId");
        Form form = (Form)this._resolver.resolveById(formId);
        this._generateFormExportXls(xslExportDirectory, form);
    }

    protected I18nizableText _getSuccessMailSubject(JobExecutionContext context) {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_SCHEDULABLE_EXPORT_XLS_SUBJECT_SUCCESS");
    }

    protected I18nizableText _getErrorMailSubject(JobExecutionContext context) {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_SCHEDULABLE_EXPORT_XLS_SUBJECT_ERROR");
    }

    protected boolean _isMailBodyInHTML(JobExecutionContext context) throws Exception {
        return true;
    }

    protected String _getSuccessMailBody(JobExecutionContext context, String language) throws IOException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String formId = jobDataMap.getString("parameterValues#formId");
        Form form = (Form)this._resolver.resolveById(formId);
        try {
            StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(this._getSuccessMailSubject(context));
            String downloadLink = this._getDownloadLink(form);
            Map<String, I18nizableText> i18nParams = Map.of("link", new I18nizableText(downloadLink), "form", new I18nizableText(form.getTitle()));
            bodyBuilder.addMessage(new I18nizableText("plugin.forms", "PLUGINS_FORMS_SCHEDULABLE_EXPORT_XLS_BODY_SUCCESS", i18nParams));
            bodyBuilder.withLink(downloadLink, new I18nizableText("plugin.forms", "PLUGINS_FORMS_SCHEDULABLE_EXPORT_XLS_BODY_DOWNLOAD_LINK"));
            bodyBuilder.withLanguage(language);
            return bodyBuilder.build();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to build HTML email body for xls export result", (Throwable)e);
            return null;
        }
    }

    protected String _getDownloadLink(Form form) throws IOException {
        Object downloadLink = StringUtils.removeEndIgnoreCase((String)((String)Config.getInstance().getValue("cms.url")), (String)"/index.html");
        downloadLink = (String)downloadLink + "/plugins/forms/download/" + form.getName() + ".xls?formId=" + form.getId();
        return downloadLink;
    }

    protected String _getErrorMailBody(JobExecutionContext context, String language, Throwable throwable) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String formId = jobDataMap.getString("parameterValues#formId");
        Form form = (Form)this._resolver.resolveById(formId);
        try {
            StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(this._getErrorMailSubject(context));
            Map<String, I18nizableText> i18nParams = Map.of("form", new I18nizableText(form.getTitle()));
            bodyBuilder.addMessage(new I18nizableText("plugin.forms", "PLUGINS_FORMS_SCHEDULABLE_EXPORT_XLS_BODY_ERROR", i18nParams));
            bodyBuilder.withLanguage(language);
            return bodyBuilder.build();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to build HTML email body for xls export result", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _generateFormExportXls(File xslExportDirectory, Form form) throws IOException {
        SitemapSource source;
        Request request;
        HashMap<String, String> parameters;
        block23: {
            File formDir = new File(xslExportDirectory, form.getName());
            if (!formDir.exists()) {
                formDir.mkdir();
            }
            parameters = new HashMap<String, String>();
            parameters.put("id", form.getId());
            request = ContextHelper.getRequest((Context)this._context);
            source = null;
            File pdfTmpFile = null;
            try {
                for (Map.Entry param : parameters.entrySet()) {
                    request.setAttribute((String)param.getKey(), param.getValue());
                }
                source = (SitemapSource)this._sourceResolver.resolveURI("cocoon://_plugins/forms/forms/entries.xls?id=" + form.getId(), null, parameters);
                String tmpFile = form.getName() + ".tmp.xls";
                pdfTmpFile = new File(formDir, tmpFile);
                try (FileOutputStream pdfTmpOs = new FileOutputStream(pdfTmpFile);
                     InputStream sourceIs = source.getInputStream();){
                    SourceUtil.copy((InputStream)sourceIs, (OutputStream)pdfTmpOs);
                }
                String fileName = form.getName() + ".xls";
                File xlsFile = new File(formDir, fileName);
                if (xlsFile.exists()) {
                    xlsFile.delete();
                }
                if (!pdfTmpFile.renameTo(xlsFile)) {
                    throw new IOException("Fail to rename " + tmpFile + " to " + fileName);
                }
                if (pdfTmpFile == null) break block23;
            }
            catch (Throwable throwable) {
                if (pdfTmpFile != null) {
                    FileUtils.deleteQuietly(pdfTmpFile);
                }
                if (source != null) {
                    this._sourceResolver.release(source);
                }
                for (Map.Entry param : parameters.entrySet()) {
                    request.removeAttribute((String)param.getKey());
                }
                throw throwable;
            }
            FileUtils.deleteQuietly((File)pdfTmpFile);
        }
        if (source != null) {
            this._sourceResolver.release((Source)source);
        }
        for (Map.Entry param : parameters.entrySet()) {
            request.removeAttribute((String)param.getKey());
        }
    }
}

