/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.content.FormManager;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockHelper;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xml.sax.SAXException;

public class FormEditionFunction
extends AbstractContentWorkflowComponent
implements EnhancedFunction {
    protected FormManager _formManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._formManager = (FormManager)((Object)manager.lookup(FormManager.ROLE));
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        this._logger.info("Performing form processing workflow function");
        WorkflowAwareContent content = this.getContent(transientVars);
        UserIdentity user = this.getUser(transientVars);
        try {
            LockableAmetysObject lockableContent = (LockableAmetysObject)content;
            if (lockableContent.isLocked() && !LockHelper.isLockOwner((LockAwareAmetysObject)lockableContent, (UserIdentity)user)) {
                throw new WorkflowException("User '" + String.valueOf(user) + "' try to save content '" + content.getName() + "' but it is locked by another user");
            }
            this._checkLock((Content)content);
            this._formManager.processContentForms((Content)content);
        }
        catch (RepositoryException e) {
            throw new WorkflowException("Unable to check lock for content " + content.getName(), (Throwable)e);
        }
        catch (AmetysRepositoryException e) {
            throw new WorkflowException("Unable to edit content " + content.getName() + " from the repository", (Throwable)e);
        }
        catch (SAXException e) {
            this._logger.error("An exception occured while parsing the form", (Throwable)e);
        }
        catch (IOException e) {
            this._logger.error("An exception occured while parsing the form", (Throwable)e);
        }
    }

    private void _checkLock(Content content) throws RepositoryException {
        Node node;
        if (content instanceof JCRAmetysObject && (node = ((JCRAmetysObject)content).getNode()).isLocked()) {
            LockManager lockManager = node.getSession().getWorkspace().getLockManager();
            Lock lock = lockManager.getLock(node.getPath());
            Node lockHolder = lock.getNode();
            lockManager.addLockToken(lockHolder.getProperty("ametys-internal:lockToken").getString());
        }
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORM_EDITION_FUNCTION_LABEL");
    }
}

