<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="service://pages/services/common/dashboard.xsl"/>
    
    <xsl:variable name="get-entry-fields-url">/admin-dashboard/form-entry/view.html</xsl:variable>
    <xsl:variable name="nb-entries-by-page"><xsl:value-of select="ametys:serviceParameter('numberOfEntries')" /></xsl:variable>
    <xsl:variable name="entries-sort-order"><xsl:value-of select="ametys:serviceParameter('entriesOrder')" /></xsl:variable>
    
    <xsl:template name="admin-dashboard-css">
        <xsl:call-template name="select2-css" />
    </xsl:template>    
    
    <xsl:template name="admin-dashboard-js">
        <xsl:call-template name="select2-js" />
        <xsl:call-template name="dashboard-helper-js" />
        <xsl:call-template name="dashboard-dialog-js" />
        <xsl:call-template name="admin-dashboard-initialize-js" />
    </xsl:template>
    
    <xsl:template name="admin-dashboard-initialize-js">
        <script type="text/javascript">
    
        $j().ready(function() {
            DashboardHelper.initializeAdmin("<xsl:value-of select="$uniqueId" />", {
                siteName: "<xsl:value-of select="$site"/>",
                lang: "<xsl:value-of select="$lang"/>",
                contextPath: "<xsl:value-of select="$site-uri-prefix"/>",
                entryUrl: "<xsl:value-of select="$get-entry-fields-url"/>",
                onShowDashboard: onShowDashboard_<xsl:value-of select="$uniqueId"/>,
                onShowEntry: onShowEntry_<xsl:value-of select="$uniqueId" />,
                onShowHistory: onShowHistory_<xsl:value-of select="$uniqueId" />,
                onShowError: onShowError_<xsl:value-of select="$uniqueId" />,
                onShowActionDialog: onShowActionDialog_<xsl:value-of select="$uniqueId" />,
                onHideActionDialog: onHideActionDialog_<xsl:value-of select="$uniqueId" />,
                dashboardView: "<xsl:value-of select="$dashboard-view"/>",
                nbEntriesByPage: "<xsl:value-of select='$nb-entries-by-page' />",
                entriesSortOrder: "<xsl:value-of select='$entries-sort-order' />",
                zoneItemId: "<xsl:value-of select="ametys:zoneItemId()" />"
            });
        });
        
        </script>
    </xsl:template>
    
    <xsl:template name="dashboard">
        <xsl:call-template name="back-to-form" />
        
        <xsl:call-template name="dashboard-title" />
        
        <xsl:call-template name="dashboard-filters"/>
    
        <xsl:call-template name="dashboard-table" />

        <xsl:apply-templates select="answer" mode="history"/>
        
        <!-- Actions that need dialog -->
        <xsl:apply-templates select="//action" mode="action-dialog"/>
    
        <xsl:call-template name="show-answer-popup" />
        
        <xsl:call-template name="show-error-popup" />
        
        <xsl:call-template name="pagination" />
    </xsl:template>
    
    <xsl:template name="back-to-form">
        <a class="back" href="javascript:DashboardHelper.goBackToForms('{$uniqueId}')"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_BACK_TO_FORMS" i18n:catalogue="plugin.forms"/></a>
    </xsl:template>
    
    <xsl:template name="dashboard-filters">
        <div data-ametys-dashboard-role="filters" class="dashboard-filters">
            <xsl:call-template name="dashboard-filters-title"/>
            <form aria-label="plugin.forms:PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FILTERS_FORM_LABEL" i18n:attr="aria-label" >
                <xsl:call-template name="dashboard-filters-submitter" />
                <xsl:call-template name="dashboard-filters-workflow" />
            </form>
        </div>
    </xsl:template>
    
    <xsl:template name="dashboard-filters-title">
        <h4 class="dashboard-filters-title"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FILTERS_TITLE" i18n:catalogue="plugin.forms"/></h4>
    </xsl:template>
    
    <xsl:template name="dashboard-filters-submitter">
        <div class="field field-combobox dashboard-filters_submitter">
            <xsl:call-template name="dashboard-filters-submitter-label"/>
            <xsl:call-template name="dashboard-filters-submitter-input"/>
            <div class="field-end"/>
        </div>
    </xsl:template>
    
    <xsl:template name="dashboard-filters-submitter-label">
        <div class="label">
            <label for="submitter-filter-{$uniqueId}"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FILTER_AUTHOR_LABEL" i18n:catalogue="plugin.forms"/></label>
        </div>
    </xsl:template>
    
    <xsl:template name="dashboard-filters-submitter-input">
        <div class="input input-select searcheable"> 
            <select id="submitter-filter-{$uniqueId}" name="submitter" >
            </select>
        </div>
    </xsl:template>
    
    <xsl:template name="dashboard-filters-workflow">
        <div class="field field-combobox dashboard-filters_workflow">
            <xsl:call-template name="dashboard-filters-workflow-label"/>
            <xsl:call-template name="dashboard-filters-workflow-input"/>
            <div class="field-end"/>
        </div>
    </xsl:template>
    
    <xsl:template name="dashboard-filters-workflow-label">
        <div class="label">
            <label for="workflow-filter-{$uniqueId}"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FILTER_WORKFLOW_LABEL" i18n:catalogue="plugin.forms"/></label>
        </div>
    </xsl:template>
    
    <xsl:template name="dashboard-filters-workflow-input">
        <div class="input input-select searcheable"> 
            <select id="workflow-filter-{$uniqueId}" name="workflow">
                <option value="">
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FILTER_WORKFLOW_EMPTY_OPTION" i18n:catalogue="plugin.forms"/>
                </option>
                <xsl:for-each select="filters/workflow-states/state">
                    <xsl:sort select="@label"/>
                    <option value="{@value}"><xsl:value-of select="@label"/></option>
                </xsl:for-each>
            </select>
        </div>
    </xsl:template>
    
    <xsl:template name="dashboard-title">
        <h3 class="form-title" id="form-title-{substring-after(@formId, 'form://')}"><xsl:value-of select="@formTitle" /></h3>
    </xsl:template>
    
    <xsl:template name="dashboard-table">
        <xsl:choose>
            <xsl:when test="count(answer) > 0">
                <table class="{$cssPrefix}__table" aria-labelledby="form-title-{substring-after(@formId, 'form://')}">
                    <xsl:call-template name="dashboard-table-header" />
                    <xsl:call-template name="dashboard-table-body" />
                </table>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-answer">
                   <p><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FORM_NO_DATA_FILTERS" i18n:catalogue="plugin.forms"/></p>
               </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="dashboard-table-header">
        <thead>
           <tr>
               <th class="{$cssPrefix}__header__id" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_ID_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__label" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_LABEL_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__user" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_USER_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__creationdate" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_CREATION_DATE_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__updatedate" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_MODIFICATION_DATE_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__workflow" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_WORKFLOW_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__history" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_HISTORY_HEADER" i18n:catalogue="plugin.forms"/></th>
               <th class="{$cssPrefix}__header__actions" scope="col"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_ACTIONS_HEADER" i18n:catalogue="plugin.forms"/></th>
           </tr>
       </thead>
    </xsl:template>
    
    <xsl:template name="dashboard-table-body">
        <tbody>
            <!-- With pagination, sort is made on the server -->
            <xsl:apply-templates select="answer" mode="row" />
        </tbody>
    </xsl:template>
    
    <xsl:template match="answer" mode="row">
        <tr>
            <xsl:apply-templates select="." mode="class-attribute"/>
            <xsl:apply-templates select="." mode="id"/>
            <xsl:apply-templates select="." mode="label"/>
            <xsl:apply-templates select="." mode="user"/>
            <xsl:apply-templates select="." mode="creation-date"/>
            <xsl:apply-templates select="." mode="update-date"/>
            <xsl:apply-templates select="." mode="workflow-step"/>
            <xsl:apply-templates select="." mode="open-history"/>
            <xsl:apply-templates select="." mode="actions"/>
        </tr>
    </xsl:template>
    
    <xsl:template match="answer" mode="id">
        <th scope="row" class="{$cssPrefix}__id">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_ID_HEADER" i18n:catalogue="plugin.forms"/></span>
            <xsl:value-of select="@number" />
        </th>
    </xsl:template>
    
    <xsl:template match="answer" mode="label">
        <td class="{$cssPrefix}__label">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_LABEL_HEADER" i18n:catalogue="plugin.forms"/></span>
            <button type="button"
                data-dashboard-open="{@formId}" 
                aria-haspopup="dialog"
                title="plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_SEE_FIELDS" i18n:attr="title">
                <xsl:attribute name="onclick">DashboardHelper.showEntry("<xsl:value-of select="$uniqueId" />", "<xsl:value-of select="@formId" />", "<xsl:value-of select="@id" />", "<xsl:value-of select="ametys:escapeJS(@formLabel)"/>", this)</xsl:attribute>
                <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_SEE_FIELDS" i18n:catalogue="plugin.forms"/></span>
            </button>
        </td>
    </xsl:template>
    
    <xsl:template match="answer" mode="user">
        <td class="{$cssPrefix}__user">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_USER_HEADER" i18n:catalogue="plugin.forms"/></span>
            <xsl:value-of select="@user" />
        </td>
    </xsl:template>
    
    <xsl:template match="answer" mode="actions">
        <xsl:variable name="formId" select="@formId" />
        <xsl:variable name="entryId" select="@id" />
        
        <td class="{$cssPrefix}__actions" data-dashboard-actions="{$formId}-{$entryId}">
            <span class="label_mobile"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_FORM_ACTIONS_HEADER" i18n:catalogue="plugin.forms"/></span>
            <ul>
                <xsl:apply-templates select="action" mode="button">
                    <xsl:with-param name="formId" select="@formId" />
                    <xsl:with-param name="entryId" select="@id" />
                </xsl:apply-templates>
            </ul>
        </td>
    </xsl:template>
    
    <xsl:template match="action[@type='edit-by-submitter']" mode="button">
        <!-- Do not display 'edit-by-submitter' action -->
    </xsl:template>
    
    <xsl:template match="action" mode="button">
        <xsl:param name="formId"/>
        <xsl:param name="entryId" />
        
        <li>
            <button type="button" class="action {@status}" onclick="DashboardHelper.doWorkflowAction('{$uniqueId}', '{@type}', '{$formId}', '{$entryId}', '{@id}', this)" title="{.}">
                <xsl:apply-templates select="." mode="button-aria-attributes"/>
                <span><xsl:value-of select="."/></span>
            </button>
        </li>
    </xsl:template>
    
    <xsl:template match="action" mode="button-aria-attributes">
    </xsl:template>
    
    <xsl:template match="action[@type='comment']" mode="button-aria-attributes">
        <xsl:attribute name="aria-haspopup">dialog</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="action[@type='edit']" mode="button-aria-attributes">
        <xsl:attribute name="aria-haspopup">dialog</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="action[@type='send-mail']" mode="button-aria-attributes">
        <xsl:attribute name="aria-haspopup">dialog</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="action[@type='comment']" mode="action-dialog">
        <div data-dashboard-popup="{$uniqueId}" data-dashboard-comment-dialog="{../@formId}-{../@id}-{@id}" style="display:none;" title="{.}">
            <xsl:call-template name="comment-form" />
        </div>
    </xsl:template>
    
    <xsl:template name="comment-form">
        <form data-dashboard-comment-form="{../@formId}-{../@id}-{@id}">
            <!-- TextArea for the comment -->
            <xsl:call-template name="comment-form-field" />
        </form>
    </xsl:template>
    
    <xsl:template name="comment-form-field">
        <div class="field field-textarea" id="field-comment_{$uniqueId}">
            <div class="label">
                <label for="comment_{$uniqueId}">
                  <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_COMMENT_DIALOG_INPUT_COMMENT" i18n:catalogue="plugin.forms"/>
                </label>
            </div>
            <div class="input input-textarea"> 
                <textarea name="comment" id="comment_{$uniqueId}" />
            </div>
            
            <div class="field-end"/>
        </div>
    </xsl:template>
    
    <xsl:template match="action[@type='edit-by-submitter']" mode="action-dialog">
        <!-- Do not display 'edit-by-submitter' action -->
    </xsl:template>
    
    <xsl:template match="action[@type='edit']" mode="action-dialog">
        <div data-dashboard-popup="{$uniqueId}" data-dashboard-edit-dialog="{../@formId}-{../@id}-{@id}" style="display:none;" title="{.}">
           <div data-dashboard-edit-values="{../@formId}-{../@id}-{@id}">
                <!-- Rendered by edit.xsl -->
           </div>
           <xsl:apply-templates select="." mode="action-dialog-loader"/>
        </div>
    </xsl:template>
    
    <xsl:template match="action[@type='send-mail']" mode="action-dialog">
        <div data-dashboard-popup="{$uniqueId}" data-dashboard-send-mail-dialog="{../@formId}-{../@id}-{@id}" style="display:none;" title="{.}">
            <p><i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_LABEL" i18n:catalogue="plugin.web"/></p>
            <xsl:call-template name="send-mail-form" />
        </div>
    </xsl:template>
    
    <xsl:template name="send-mail-form">
        <form data-dashboard-send-mail-form="{../@formId}-{../@id}-{@id}">
            <!-- Checkbox to send mail -->
            <xsl:call-template name="send-mail-form-send-mail-field" />
            <!-- Input text for the sender -->
            <xsl:call-template name="send-mail-form-sender-field" />
            <!-- Select for the recipient -->
            <xsl:call-template name="send-mail-form-recipient-field" />
            <!-- Input text for the mail subject -->
            <xsl:call-template name="send-mail-form-subject-field" />
            <!-- TextArea for the mail body -->
            <xsl:call-template name="send-mail-form-body-field" />
        </form>
    </xsl:template>
    
    <xsl:template name="send-mail-form-send-mail-field">
        <div class="field field-checkbox" id="field-send-mail_{$uniqueId}">
            <div class="label">
                <label for="send-mail_{$uniqueId}">
                  <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_SEND_MAIL_DIALOG_INPUT_SEND_MAIL" i18n:catalogue="plugin.forms"/>
                </label>
            </div>
            <div class="input input-checkbox"> 
                <input type="checkbox" name="send-mail" id="send-mail_{$uniqueId}" checked="true" onchange="onChange"/>
            </div>
            
            <div class="field-end"/>
        </div>
        <script>
            $j(document).ready(function () {
              $j('#send-mail_<xsl:value-of select="$uniqueId"/>').change(function () {
                
                var checked = $j(this).is(':checked');
                var form = $j(this).closest("form");
                
                form.find("select[name='recipient']").prop( "disabled", !checked);
                form.find("input[name='subject']").prop( "disabled", !checked);
                form.find("textarea[name='body']").prop( "disabled", !checked);
              });
            });
        </script>
    </xsl:template>
    
    <xsl:template name="send-mail-form-sender-field">
        <div class="field" id="field-sender_{$uniqueId}">
            <div class="label">
                <label for="sender_{$uniqueId}">
                  <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_SEND_MAIL_DIALOG_INPUT_SENDER" i18n:catalogue="plugin.forms"/> <span class="mandatory-marker">*</span>
                </label>
            </div>
            <div class="input"> 
                <input disabled="true" type="input" name="sender-display" id="sender_{$uniqueId}" value="{../sender-fullname}" aria-required="true"/>
                <input type="hidden" name="sender" value="{../sender-mail}" />
            </div>
            
            <div class="field-end"/>
        </div>
    </xsl:template>
    
    <xsl:template name="send-mail-form-recipient-field">
        <div class="field field-combobox" id="field-recipient_{$uniqueId}">
            <div class="label">
                <label for="recipient_{$uniqueId}">
                  <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_SEND_MAIL_DIALOG_INPUT_RECIPIENT" i18n:catalogue="plugin.forms"/> <span class="mandatory-marker">*</span>
                </label>
            </div>
            <div class="input input-select"> 
                <select name="recipient" id="recipient_{$uniqueId}" aria-required="true">
                    <xsl:for-each select="../receivers/receiver">
                        <option value="{receiver-mail}"><xsl:value-of select="receiver-fullname" /></option>
                    </xsl:for-each>
                </select>
            </div>
            
            <div class="field-end"/>
        </div>
    </xsl:template>
    
    <xsl:template name="send-mail-form-subject-field">
        <div class="field" id="field-subject_{$uniqueId}">
            <div class="label">
                <label for="subject_{$uniqueId}">
                  <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_SEND_MAIL_DIALOG_INPUT_SUBJECT" i18n:catalogue="plugin.forms"/>
                </label>
            </div>
            <div class="input"> 
                <input type="input" name="subject" id="subject_{$uniqueId}" value="plugin.forms:FORMS_DEFAULT_WORKFLOW_NEED_COMPLEMENTS_DIALOG_SUBJECT_DEFAULT" i18n:attr="value" />
            </div>
            
            <div class="field-end"/>
        </div>
    </xsl:template>
    
    <xsl:template name="send-mail-form-body-field">
        <div class="field field-textarea" id="field-body_{$uniqueId}">
            <div class="label">
                <label for="body_{$uniqueId}">
                  <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_SEND_MAIL_DIALOG_INPUT_BODY" i18n:catalogue="plugin.forms"/>
                </label>
            </div>
            <div class="input input-textarea"> 
                <textarea name="body" id="body_{$uniqueId}" >
                    <i18n:text i18n:key="FORMS_DEFAULT_WORKFLOW_NEED_COMPLEMENTS_DIALOG_BODY_INPUT_DEFAULT" i18n:catalogue="plugin.forms"/>
                </textarea>
            </div>
            
            <div class="field-end"/>
        </div>
    </xsl:template>
    
    <xsl:template match="action" mode="action-dialog"/>
    
    <xsl:template name="pagination">
        <xsl:if test="@page > 1 or @hasNextPage = 'true'">
            <nav class="pagination" aria-label="plugin.forms:PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FORM_NAV_ARIA_LABEL" i18n:attr="aria-label" role="navigation">
                <ul>
                    <xsl:if test="@page > 1">
                        <li>
                            <button type="button" class="previous" onclick="DashboardHelper.showAdminDashboard('{$uniqueId}', '{@formId}', {@page - 1})" aria-label="plugin.forms:PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FORM_PREVIOUS_PAGE_ARIA_LABEL" i18n:attr="aria-label">
                                <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FORM_PREVIOUS_PAGE" i18n:catalogue="plugin.forms"/></span>
                            </button>
                        </li>
                    </xsl:if>
                    <xsl:if test="@hasNextPage = 'true'">
                        <li>
                            <button type="button"  class="next" onclick="DashboardHelper.showAdminDashboard('{$uniqueId}', '{@formId}', {@page + 1})" aria-label="plugin.forms:PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FORM_NEXT_PAGE_ARIA_LABEL" i18n:attr="aria-label">
                                <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_ADMIN_DASHBOARD_FORM_NEXT_PAGE" i18n:catalogue="plugin.forms"/></span>
                            </button>
                        </li>
                    </xsl:if>
                </ul>
             </nav>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
