/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Controller used to set active the various input tabs not only when clicking in the input but also on its label
 */
Ext.define('Ametys.plugins.forms.content.controller.FormsTabController', {
	
	extend: 'Ametys.ribbon.element.tab.EditionTabController',
	
	_getNode: function(base)
	{
	    // FIXME "tinyMCE.activeEditor" a better method is to use the field.getEditor()
		var node = tinyMCE.activeEditor.dom.getParent(base, "label");
		if (node != null)
		{
			var id = node.htmlFor;
			if (id != null)
			{
				var field = tinyMCE.activeEditor.dom.get(id);
				if (field != null)
				{
					return field;
				}
			}
		}
		
		return base;
	}
});

