/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that is able to check for conditions on
 * the rights of a Form.
 * @private
 */
Ext.define('Ametys.plugins.forms.controllers.FormDirectoryController', {
    extend: 'Ametys.plugins.forms.controllers.FormController',
    
    /**
     * @cfg {String} [enable-on-renameaccess-only="false"] If 'true' the button will be disabled as soon as the current user has no rename access on selection
     */
	/**
     * @cfg {String} [norenameaccess-description] Error message to display in tooltip when the user has no rename. Use if #cfg-enable-on-renameaccess-only is true
     */
	
	_updateTooltipDescription: function(description, params)
    {
		description = this.callParent(arguments);
		
		var enabledOnRenameAccessOnly = this.getConfig("enable-on-renameaccess-only") == "true";
        if (enabledOnRenameAccessOnly && !params.formDirectory.canRename())
        {
            description = this._addTooltipDescription(description, "norenameaccess");
			this._hasError = true;
        }
        return description;
    }
});
