<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:stringutils="org.ametys.core.util.StringUtils"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    extension-element-prefixes="stringutils">
    
	<xsl:param name="contextPath" />
	<xsl:param name="cms-context" />
	<xsl:param name="plugin" />
	<xsl:param name="site" />
    
    <xsl:template match="/">
        <html>
            <head/>
            <body>
                <xsl:apply-templates select="form"/>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="form">
        <table>
            <xsl:if test="columns/column">
                <thead>
                    <tr>
                        <th><i18n:text i18n:key="PLUGINS_FORMS_EXPORT_COLUMN_ID"/></th>
                        <th><i18n:text i18n:key="PLUGINS_FORMS_EXPORT_COLUMN_DATE"/></th>
                        <xsl:for-each select="columns/column">
                            <th>
                                <xsl:choose>
                                    <xsl:when test="normalize-space(@label) != ''"><xsl:value-of select="@label"/></xsl:when>
                                    <xsl:otherwise><xsl:value-of select="@field-name"/></xsl:otherwise>
                                </xsl:choose>
                            </th>
                        </xsl:for-each>
                        <th><i18n:text i18n:key="PLUGINS_FORMS_EXPORT_COLUMN_WORKFLOW_STEP"/></th>
                    </tr>
                </thead>
            </xsl:if>
            
            <tbody>
                <xsl:for-each select="entry">
                    <tr>
                        <td>
                            <xsl:value-of select="@id"/>
                        </td>
                        <td>
                            <xsl:if test="@submission-date">
                                <i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ssZ" pattern="short"><xsl:value-of select="@submission-date"/></i18n:date-time>
                            </xsl:if>
                        </td>
                        <xsl:for-each select="field">
                            <xsl:variable name="type" select="ancestor::form/columns/column[@id = current()/@id]/@type"/>
                            <td>
                                <xsl:choose>
                                    <xsl:when test="$type = 'FILE'">
                                        <a href="{$contextPath}/plugins/{$plugin}/{$site}/download/{ancestor::form/@id}/{../@id}/{@id}/{text()}"><xsl:value-of select="text()"/></a>
                                    </xsl:when>
                                    <xsl:when test="$type = 'CHECKBOX'">
                                        <xsl:choose>
                                            <xsl:when test="text() = 'true'">
                                            	<xsl:choose>
		                                            <xsl:when test="@defaultvalue"><xsl:value-of select="@defaultvalue"/></xsl:when>
	                                            	<xsl:otherwise><i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_TRUE"/></xsl:otherwise>
                                            	</xsl:choose>
                                            </xsl:when>
                                            <xsl:otherwise>
                                            	<xsl:choose>
		                                            <xsl:when test="@defaultvalue"></xsl:when>
	                                            	<xsl:otherwise><i18n:text i18n:key="PLUGINS_FORMS_MAIL_RESULTS_FALSE"/></xsl:otherwise>
	                                            </xsl:choose>
	                                        </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:when test="@value">
                                    	<xsl:value-of select="stringutils:sanitizeXlsHtml(@value)"/>
                                    </xsl:when>                                    
                                    <xsl:otherwise>
                                        <xsl:value-of select="stringutils:sanitizeXlsHtml(.)"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </td>
                        </xsl:for-each>
                        <td>
                            <xsl:if test="@workflowStep">
                                <xsl:value-of select="@workflowStep" />
                            </xsl:if>
                        </td>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
    </xsl:template>
    
</xsl:stylesheet>
