<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
    exclude-result-prefixes="ametys">

    <xsl:import href="view://stylesheets/forms/questions/choices-list/checkboxes.xsl"/>
    <xsl:import href="view://stylesheets/forms/questions/choices-list/combobox.xsl"/>
    
    <xsl:variable name="other-val">__internal_other</xsl:variable>
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode="question-attribute-class">
        <xsl:attribute name="class">question question-choice</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'checkbox']">
        <div class="question">
            <xsl:apply-templates select="." mode="question-attribute-class"/>
            
            <div class="field" role="group" aria-label="{title}">
                <xsl:apply-templates select="." mode="field-attribute-class"/>
                
                <xsl:apply-templates select="." mode="label"/>
                
                <xsl:apply-templates select="." mode="picture"/>
                
                <xsl:choose>
                    <xsl:when test="@canWrite = 'true'">
                        <xsl:apply-templates select="." mode="input"/>
                        <xsl:apply-templates select="." mode="additional-field"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="." mode="read-only"/>
                    </xsl:otherwise>
                </xsl:choose>
                
                <div class="field-end"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode="read-only">
        <div class="{$cssPrefix}__item_value">
            <xsl:choose>
                <xsl:when test="entry-value/additional-infos/values/value">
                    <xsl:apply-templates select="." mode="read-only-value">
                        <xsl:with-param name="value" select="entry-value/additional-infos/values/value" />
                    </xsl:apply-templates>    
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_EMPTY_VALUE" i18n:catalogue="plugin.forms"/>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template> 
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode="read-only-value">
        <xsl:param name="value" />
        
        <xsl:choose>
            <xsl:when test="count($value) > 1">
                <ul>
                <xsl:for-each select="$value">
                    <li>
                        <xsl:apply-templates select="." mode="read-only-value-option" />
                    </li>
                </xsl:for-each>
                </ul>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="$value" mode="read-only-value-option" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode="render-mail">
        <xsl:if test="additional-infos/values/value">
            <xsl:choose>
                <xsl:when test="count(additional-infos/values/value) > 1">
                    <xsl:for-each select="additional-infos/values/value">
                        <xsl:variable name="value" select="." />
                        <xsl:variable name="label" select="label" />
                        <xsl:choose>
                           <xsl:when test="$label != ''">
                               <xsl:value-of select="$label" />
                           </xsl:when>
                           <xsl:otherwise>
                               <xsl:value-of select="$value" />
                           </xsl:otherwise>
                        </xsl:choose>
                        <xsl:if test="position() != last()">
                            <xsl:text>, </xsl:text>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="optionValue" select="additional-infos/values/value" />
                    <xsl:variable name="label" select="additional-infos/values/value/label" />
                    <xsl:choose>
                       <xsl:when test="$label != ''">
                           <xsl:value-of select="$label" />
                       </xsl:when>
                       <xsl:otherwise>
                           <xsl:value-of select="$optionValue" />
                       </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="value" mode="read-only-value-option">
        <span>
            <xsl:if test="@cost">
                <xsl:attribute name="data-cost-value"><xsl:value-of select="@cost" /></xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="label != ''">
                    <xsl:value-of select="label" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="." />
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    
    <xsl:template match="question[@type = 'form.ChoicesList' and format/@value = 'checkbox' and additional-infos/options/@remoteData = 'true']">
        <div class="question">
            <xsl:if test="$preview = 'true'">
                <xsl:variable name="htmlMessage">
                    <i18n:text i18n:key="PLUGINS_FORMS_CHOICE_LIST_INCOMPATIBLE_ERROR"/>
                </xsl:variable>
                        
                <xsl:call-template name="display-bo-warning-message">
                    <xsl:with-param name="titleI18nKey" select="'plugin.forms:PLUGINS_FORMS_CHOICE_LIST_INCOMPATIBLE_ERROR_TITLE'"/>
                    <xsl:with-param name="htmlMessage" select="$htmlMessage"/>
                </xsl:call-template>
            </xsl:if>
        </div>
    </xsl:template> 
    
    <xsl:template match="question[@type = 'form.ChoicesList']" mode="init-rules">
            <xsl:apply-templates select="." mode="listener"/>
    </xsl:template>
    
</xsl:stylesheet>