<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://docbook.org/ns/docbook"
	xmlns:html="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:math="http://exslt.org/math" xmlns:dyn="http://exslt.org/dynamic"
	xmlns:xalan="http://xml.apache.org/xalan" xmlns:editor="org.ametys.cms.transformation.xslt.InlineEditorHelper"
	xmlns:xlink="http://www.w3.org/1999/xlink" exclude-result-prefixes="math dyn xalan editor">

	<xsl:output method="xml" indent="yes" />

	<xsl:template match="form[not(ancestor::form)]">
		<html:form>
			<xsl:copy-of select="@*" />
			<xsl:apply-templates
				select="p|div|ol|ul|table|*[starts-with(name(),'h') and string-length(name())=2 and string(number(substring(name(),2,1)))!='NaN']|label|input|textarea|select|fieldset|legend|captcha" />
		</html:form>
	</xsl:template>

	<xsl:template match="label">
		<html:label>
			<xsl:copy-of select="@*" />
			<xsl:value-of select="." />
		</html:label>
	</xsl:template>

	<xsl:template match="input">
		<html:input>
			<xsl:copy-of select="@*" />
			<xsl:value-of select="." />
		</html:input>
	</xsl:template>

	<xsl:template match="textarea">
		<html:textarea>
			<xsl:copy-of select="@*" />
			<xsl:value-of select="." />
		</html:textarea>
	</xsl:template>

	<xsl:template match="select">
		<html:select>
			<xsl:copy-of select="@*" />
			<xsl:apply-templates select="option" />
		</html:select>
	</xsl:template>

	<xsl:template match="option">
		<html:option>
			<xsl:copy-of select="@*" />
			<xsl:value-of select="." />
		</html:option>
	</xsl:template>

	<xsl:template match="fieldset">
		<html:fieldset>
			<xsl:copy-of select="@*" />
			<xsl:apply-templates />
		</html:fieldset>
	</xsl:template>

	<xsl:template match="legend">
		<html:legend>
			<xsl:copy-of select="@*" />
			<xsl:value-of select="." />
		</html:legend>
	</xsl:template>

	<xsl:template match="captcha">
		<html:captcha>
			<xsl:copy-of select="@*" />
		</html:captcha>
	</xsl:template>

</xsl:stylesheet>