/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms;

/**
 * Events relative to forms.
 */
public interface FormEvents
{
    
    /** Fired when a form is created. */
    public static final String FORM_CREATED = "form.created";
    
    /** Fired when a form is modified. */
    public static final String FORM_MODIFIED = "form.modified";
    
    /** Fired when a form is deleted. */
    public static final String FORM_DELETED = "form.deleted";
    
    
}
