/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.content.data;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.util.URIUtils;
import org.ametys.plugins.forms.FormsException;
import org.ametys.plugins.forms.content.Form;
import org.ametys.plugins.forms.content.jcr.FormPropertiesManager;

/**
 * This action adds file attachment HTTP header to the response for XSL export
 */
public class SetHttpHeaderForExport extends ServiceableAction
{
    private FormPropertiesManager _formPropertiesManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _formPropertiesManager = (FormPropertiesManager) smanager.lookup(FormPropertiesManager.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        String siteName = parameters.getParameter("site", "");
        String formId = parameters.getParameter("id", "");
        
        if (StringUtils.isEmpty(siteName) || StringUtils.isEmpty(formId))
        {
            throw new ProcessingException("The site name and form ID must be provided.");
        }
        
        try
        {
            Form form = _formPropertiesManager.getForm(siteName, formId);
            
            if (form == null)
            {
                throw new ProcessingException("The form of ID '" + formId + " can't be found in the site '" + siteName + "'.");
            }
            
            String fileName = URIUtils.decode(form.getLabel());
            String encodedName = URIUtils.encodeHeader(fileName);
            
            Response response = ObjectModelHelper.getResponse(objectModel);
            
            response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedName + ".xls\";filename*=UTF-8''" + encodedName + ".xls");
        }
        catch (FormsException e)
        {
            getLogger().error("Unable to get form with id " + formId, e);
        }
        
        return EMPTY_MAP;
    }
}
