/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.sources;

import java.util.Map;

/**
 * Class for creating choices options with emails
 */
public class ChoiceOptionWithEmail extends ChoiceOption
{
    private String _emails;

    /**
     * Create a {@link ChoiceOptionWithEmail}
     * @param value value of option
     * @param email email of option
     */
    public ChoiceOptionWithEmail(Object value, String email)
    {
        super(value);
        _emails = email;
    }

    /**
     * Get the emails of option
     * @return the emails
     */
    public String getEmails()
    {
        return _emails;
    }
    
    @Override
    public Map<String, Object> getAttributes() 
    {
        Map<String, Object> attrs = super.getAttributes();
        attrs.put("emails", getEmails());
        return attrs;
    }
}
