/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.types;

import java.util.List;

import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;

import com.opensymphony.workflow.loader.WorkflowDescriptor;

/**
 * Provide all the necessary method to add workflow restriction to a question type
 */
public interface RestrictiveAwareQuestionType
{
    /** Constant for reading workflows data attribute. */
    public static final String ATTRIBUTE_READING_CHECKBOX = "readingCheckbox";
    /** Constant for reading workflows data attribute. */
    public static final String ATTRIBUTE_WRITING_CHECKBOX = "writingCheckbox";
    /** Constant for reading workflows data attribute. */
    public static final String ATTRIBUTE_READING = "reading";
    /** Constant for writing workflows data attribute. */
    public static final String ATTRIBUTE_WRITING = "writing";
    /** Constant for writing workflows data attribute. */
    public static final Long INITIAL_WORKFLOW_ID = 0L;
    
    /**
     * Provide a list of model items that must be included in the model items return by the method FormQuestionType.getModel
     * @return a list of model items
     */
    public List<ModelItem> getRestrictiveModelItems();
    
    /**
     * Get the workflow descriptor of the form
     * @param form the form
     * @return he workflow descriptor
     */
    public WorkflowDescriptor getWorkflowDescriptor(Form form);
    
    /**
     * Get the view's common illustration tab
     * @param model the model of the question type
     * @param form the form
     * @return the illustration tab as SimpleViewItemGroup
     */
    public SimpleViewItemGroup getRestrictiveTab(Model model, Form form);

    /**
     * <code>true</code> if the question is read restricted
     * @param question the question
     * @return <code>true</code> if the question is read restricted
     */
    public boolean isReadRestricted(FormQuestion question);

    /**
     * <code>true</code> if the question is modifiable
     * @param question the question
     * @return <code>true</code> if the question is  modifiable
     */
    public boolean isModifiable(FormQuestion question);

    /**
     * Get the steps that allows reading
     * @param question the question
     * @return the steps that allows reading
     */
    public List<Long> getReadingSteps(FormQuestion question);

    /**
     * Get the steps that allows writing
     * @param question the question
     * @return the steps that allows writing
     */
    public List<Long> getWritingSteps(FormQuestion question);
}
