/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.question.validators;

import org.apache.commons.lang3.StringUtils;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.ValidationResult;
/**
 * Validator for input name for forms 
 */
public class NameForFormValidator extends DefaultValidator
{
    /**
     * A name for form validator
     * @param regexp the regexp
     * @param mandatory true is mandatory
     */
    public NameForFormValidator (String regexp, boolean mandatory)
    {
        super(regexp, mandatory);
    }
    
    @Override
    protected ValidationResult validateSingleValue(Object value)
    {
        ValidationResult result = super.validateSingleValue(value);
        
        if (StringUtils.startsWith((CharSequence) value, "ametys-"))
        {
            result.addError(new I18nizableText("plugin.forms", "PLUGINS_FORMS_FORMS_RENDER_ERROR_NAME_FOR_FORM"));
        }
        
        return result;
    }
    
    @Override
    protected ValidationResult validateArrayValues(Object[] values)
    {
        ValidationResult result = super.validateArrayValues(values);
        
        for (Object valueToValidate : values)
        {
            result.addResult(validateSingleValue(valueToValidate));
        }
        
        return result;
    }
}
