/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.repository;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Updates copied form's internal attributes
 */
public abstract class AbstractFormCopyUpdater implements CopyFormUpdater, Serviceable
{
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    /**
     * Get the copied page 
     * @param createdForm the form copy
     * @param originalFormPage the original page
     * @return the page copy 
     */
    protected FormPage _getCopiedPage(Form createdForm, FormPage originalFormPage)
    {
        return createdForm.getChild(originalFormPage.getName());
    }

    /**
     * Get the copied question
     * @param createdForm the form copy
     * @param originalFormQuestion the original question
     * @return the question copy
     */
    protected FormQuestion _getCopiedQuestion(Form createdForm, FormQuestion originalFormQuestion)
    {
        return createdForm.getQuestion(originalFormQuestion.getNameForForm());
    }
    
}
