/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.content.processing;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.ametys.web.URIPrefixHandler;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetContentAction
extends org.ametys.cms.content.GetContentAction {
    private SiteManager _siteManager;
    private SkinsManager _skinsManager;
    private URIPrefixHandler _uriPrefixHandler;
    private RightManager _rightManager;
    private CurrentUserProvider _currentUserProvied;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._skinsManager = (SkinsManager)serviceManager.lookup(SkinsManager.ROLE);
        this._uriPrefixHandler = (URIPrefixHandler)this.manager.lookup(URIPrefixHandler.ROLE);
        this._rightManager = (RightManager)this.manager.lookup(RightManager.ROLE);
        this._currentUserProvied = (CurrentUserProvider)this.manager.lookup(CurrentUserProvider.ROLE);
    }

    public Map<String, String> act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map result = super.act(redirector, resolver, objectModel, source, parameters);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String pluginName = (String)request.getAttribute("pluginName");
        Object url = "";
        Content content = (Content)request.getAttribute(Content.class.getName());
        if (content instanceof WebContent) {
            WebContent webContent = (WebContent)content;
            if (!this._rightManager.currentUserHasReadAccess((Object)webContent)) {
                UserIdentity user = this._currentUserProvied.getUser();
                if (user == null) {
                    throw new AuthorizationRequiredException();
                }
                throw new AccessDeniedException("User '" + UserIdentity.userIdentityToString((UserIdentity)user) + "' can not post form for content '" + webContent.getId() + "'");
            }
            request.setAttribute("IsSitemapRestrictedAction$donotcheckrights", (Object)true);
            String siteName = webContent.getSiteName();
            String lang = webContent.getLanguage();
            String template = null;
            result.put("site", siteName);
            result.put("lang", lang);
            String revision = ((VersionableAmetysObject)content).getRevision();
            ((VersionableAmetysObject)content).switchToRevision(null);
            Iterator pages = webContent.getReferencingPages().iterator();
            if (pages.hasNext()) {
                template = ((Page)pages.next()).getTemplate();
            } else {
                Site site = this._siteManager.getSite(siteName);
                Sitemap sitemap = site.getSitemap(lang);
                String absoluteUriPrefix = this._uriPrefixHandler.getAbsoluteUriPrefix(siteName) + "/" + lang + "/";
                String referer = request.getHeader("Referer");
                if (referer != null && referer.startsWith(absoluteUriPrefix)) {
                    String pathInSitemap = referer.substring(absoluteUriPrefix.length());
                    try {
                        Page page = (Page)sitemap.getChild(pathInSitemap.substring(0, pathInSitemap.indexOf(".html")));
                        template = page.getTemplate();
                    }
                    catch (UnknownAmetysObjectException e) {
                        template = this._getDefaultTemplate(site);
                    }
                } else {
                    template = this._getDefaultTemplate(site);
                }
            }
            url = "cocoon://" + siteName + "/" + lang + "/_plugins/" + pluginName + "/" + template + "/process-form";
            result.put("template", template);
            result.put("url", url);
            ((VersionableAmetysObject)content).switchToRevision(revision);
        } else {
            url = "cocoon:/process-form";
            result.put("url", url);
        }
        return result;
    }

    private String _getDefaultTemplate(Site site) {
        String skinName = site.getSkinId();
        Skin skin = this._skinsManager.getSkin(skinName);
        Set templates = skin.getTemplates();
        if (templates.contains("page")) {
            return "page";
        }
        return (String)templates.iterator().next();
    }
}

