/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types.impl;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.data.holder.DataHolderRelativeDisableCondition;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditions;
import org.ametys.plugins.forms.question.sources.ChoiceOption;
import org.ametys.plugins.forms.question.sources.ChoiceSourceType;
import org.ametys.plugins.forms.question.sources.ChoiceSourceTypeExtensionPoint;
import org.ametys.plugins.forms.question.sources.ManualWithCostsSourceType;
import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.question.types.MultipleAwareQuestionType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ChoicesListQuestionType
extends AbstractFormQuestionType
implements MultipleAwareQuestionType {
    public static final String ATTRIBUTE_SOURCE_TYPE = "source-type";
    public static final String ATTRIBUTE_OTHER = "other-option";
    public static final String ATTRIBUTE_FORMAT = "format";
    public static final String ATTRIBUTE_PLACEHOLDER = "placeholder";
    public static final String DEFAULT_TYPE_ID = "org.ametys.plugins.forms.question.sources.Manual";
    public static final String CHECKBOX_FORMAT_VALUE = "checkbox";
    public static final String COMBOBOXBOX_FORMAT_VALUE = "combobox";
    public static final String OTHER_OPTION_VALUE = "__internal_other";
    public static final String OTHER_PREFIX_DATA_NAME = "ametys-other-";
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_CHOICE_LIST";
    protected ChoiceSourceTypeExtensionPoint _choiceSourceTypeExtensionPoint;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._choiceSourceTypeExtensionPoint = (ChoiceSourceTypeExtensionPoint)((Object)manager.lookup(ChoiceSourceTypeExtensionPoint.ROLE));
    }

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        ElementDefinition sourceType = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_SOURCE_TYPE, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICES_SOURCE_TYPE", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICES_SOURCE_TYPE_DESC", null);
        StaticEnumerator typesStaticEnumerator = new StaticEnumerator();
        for (ChoiceSourceType type : this._choiceSourceTypeExtensionPoint.getAllSourceType()) {
            typesStaticEnumerator.add(type.getLabel(), (Object)type.getId());
            DataHolderRelativeDisableConditions disableConditions = new DataHolderRelativeDisableConditions();
            DataHolderRelativeDisableCondition condition = new DataHolderRelativeDisableCondition(ATTRIBUTE_SOURCE_TYPE, DisableCondition.OPERATOR.NEQ, type.getId(), true, this._disableConditionsHelper);
            disableConditions.getConditions().add(condition);
            Map<String, ModelItem> typeModelItems = type.getModelItems();
            for (ModelItem item : typeModelItems.values()) {
                item.setDisableConditions((DisableConditions)disableConditions);
            }
            modelItems.addAll(typeModelItems.values());
        }
        sourceType.setEnumerator((Enumerator)typesStaticEnumerator);
        sourceType.setDefaultValue((Object)DEFAULT_TYPE_ID);
        modelItems.add((ModelItem)sourceType);
        modelItems.add(this.getMultipleModelItem());
        ElementDefinition other = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_OTHER, "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_OTHER", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_OTHER_DESC", null);
        modelItems.add((ModelItem)other);
        ElementDefinition format = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_FORMAT, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_FORMAT", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_FORMAT_DESC", null);
        StaticEnumerator formatStaticEnumerator = new StaticEnumerator();
        formatStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_FORMAT_CHECKBOX"), (Object)CHECKBOX_FORMAT_VALUE);
        formatStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_FORMAT_COMBOBOX"), (Object)COMBOBOXBOX_FORMAT_VALUE);
        format.setEnumerator((Enumerator)formatStaticEnumerator);
        format.setDefaultValue((Object)COMBOBOXBOX_FORMAT_VALUE);
        modelItems.add((ModelItem)format);
        ElementDefinition placeholder = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_PLACEHOLDER, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_PLACEHOLDER", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_PLACEHOLDER_DESC", null);
        DataHolderRelativeDisableConditions placeholderConditions = new DataHolderRelativeDisableConditions();
        placeholderConditions.getConditions().add(new DataHolderRelativeDisableCondition(ATTRIBUTE_FORMAT, DisableCondition.OPERATOR.NEQ, COMBOBOXBOX_FORMAT_VALUE, this._disableConditionsHelper));
        placeholder.setDisableConditions((DisableConditions)placeholderConditions);
        modelItems.add((ModelItem)placeholder);
        return modelItems;
    }

    @Override
    protected SimpleViewItemGroup _getMainTab() {
        SimpleViewItemGroup mainFieldset = super._getMainTab();
        ViewElement format = new ViewElement();
        format.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_FORMAT));
        mainFieldset.addViewItem((ViewItem)format);
        ViewElement placeholder = new ViewElement();
        placeholder.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_PLACEHOLDER));
        mainFieldset.addViewItem((ViewItem)placeholder);
        ViewElement sourceCombobox = new ViewElement();
        sourceCombobox.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_SOURCE_TYPE));
        mainFieldset.addViewItem((ViewItem)sourceCombobox);
        for (ChoiceSourceType type : this._choiceSourceTypeExtensionPoint.getAllSourceType()) {
            mainFieldset.addViewItems(type.getViewItems());
        }
        return mainFieldset;
    }

    @Override
    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._getAdvancedTab();
        advancedFieldset.addViewItem((ViewItem)this.getMultipleViewElement(this.getModel()));
        ViewElement other = new ViewElement();
        other.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_OTHER));
        advancedFieldset.addViewItem((ViewItem)other);
        return advancedFieldset;
    }

    public Map<String, I18nizableText> getOptions(FormQuestion question) {
        LinkedHashMap<String, I18nizableText> options = new LinkedHashMap<String, I18nizableText>();
        ChoiceSourceType type = (ChoiceSourceType)this._choiceSourceTypeExtensionPoint.getExtension((String)question.getValue(ATTRIBUTE_SOURCE_TYPE));
        if (!type.remoteData()) {
            try {
                HashMap<String, Object> enumParam = new HashMap<String, Object>();
                enumParam.put("question", (Object)question);
                Map optionsToMap = type.getTypedEntries(enumParam);
                for (ChoiceOption option : optionsToMap.keySet()) {
                    options.put((String)option.getValue(), optionsToMap.get(option));
                }
            }
            catch (Exception e) {
                this.getLogger().error("An error occured while getting options for question " + question.getId());
            }
        }
        return options;
    }

    @Override
    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
        super.saxAdditionalInfos(contentHandler, question);
        ChoiceSourceType type = (ChoiceSourceType)this._choiceSourceTypeExtensionPoint.getExtension((String)question.getValue(ATTRIBUTE_SOURCE_TYPE));
        try {
            AttributesImpl attrsOption = new AttributesImpl();
            attrsOption.addCDATAAttribute("remoteData", String.valueOf(type.remoteData()));
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"options", (Attributes)attrsOption);
            if (!type.remoteData()) {
                HashMap<String, Object> enumParam = new HashMap<String, Object>();
                enumParam.put("question", (Object)question);
                Map options = type.getTypedEntries(enumParam);
                for (ChoiceOption option : options.keySet()) {
                    AttributesImpl attrsImpl = new AttributesImpl();
                    Map<String, Object> attrs = option.getAttributes();
                    for (String key : attrs.keySet()) {
                        attrsImpl.addCDATAAttribute(key, attrs.get(key).toString());
                    }
                    attrsImpl.addCDATAAttribute(ATTRIBUTE_FORMAT, (String)question.getValue(ATTRIBUTE_FORMAT));
                    attrsImpl.addCDATAAttribute("multiple", String.valueOf(this.isMultiple(question)));
                    XMLUtils.startElement((ContentHandler)contentHandler, (String)"option", (Attributes)attrsImpl);
                    options.get(option).toSAX(contentHandler, "label");
                    XMLUtils.endElement((ContentHandler)contentHandler, (String)"option");
                }
            }
            if (this.hasOtherOption(question)) {
                AttributesImpl otherAttrs = new AttributesImpl();
                otherAttrs.addCDATAAttribute(ATTRIBUTE_FORMAT, (String)question.getValue(ATTRIBUTE_FORMAT));
                otherAttrs.addCDATAAttribute("multiple", String.valueOf(this.isMultiple(question)));
                otherAttrs.addCDATAAttribute("other", "true");
                otherAttrs.addCDATAAttribute("value", OTHER_OPTION_VALUE);
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"option", (Attributes)otherAttrs);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"options");
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while saxing addionnal infos of the select.", (Throwable)e);
        }
    }

    @Override
    public String getStorageType(FormQuestion question) {
        ChoiceSourceType sourceType = this.getSourceType(question);
        if (sourceType != null) {
            return sourceType.getStorageType(question);
        }
        return "string";
    }

    @Override
    protected ModelItem _getEntryModelItem(FormQuestion question) {
        ModelItem item = super._getEntryModelItem(question);
        ((ElementDefinition)item).setMultiple(this.isMultiple(question));
        return item;
    }

    @Override
    public void doAdditionalOperations(FormQuestion question, Map<String, Object> values) {
        super.doAdditionalOperations(question, values);
        String sourceType = (String)values.get(ATTRIBUTE_SOURCE_TYPE);
        if (DEFAULT_TYPE_ID.equals(sourceType) && values.containsKey("select-grid")) {
            question.setValue("select-grid-costs", values.get("select-grid"));
        }
        if ("org.ametys.plugins.forms.question.sources.ManualWithCosts".equals(sourceType) && values.containsKey("select-grid-costs")) {
            question.setValue("select-grid", values.get("select-grid-costs"));
        }
    }

    @Override
    public I18nizableText getDefaultTitle() {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }

    @Override
    public boolean isQuestionConfigured(FormQuestion question) {
        try {
            String format = (String)question.getValue(ATTRIBUTE_FORMAT);
            ChoiceSourceType sourceType = this.getSourceType(question);
            if (sourceType.remoteData() && CHECKBOX_FORMAT_VALUE.equals(format)) {
                return false;
            }
            HashMap<String, Object> enumParam = new HashMap<String, Object>();
            enumParam.put("question", (Object)question);
            if (sourceType.remoteData()) {
                return !sourceType.searchEntries(enumParam, 1, null).isEmpty();
            }
            return !sourceType.getTypedEntries(enumParam).isEmpty();
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred getting values of source type for question with id '{}'", (Object)question.getId(), (Object)e);
            return false;
        }
    }

    public ChoiceSourceType getSourceType(FormQuestion question) {
        return (ChoiceSourceType)this._choiceSourceTypeExtensionPoint.getExtension((String)question.getValue(ATTRIBUTE_SOURCE_TYPE));
    }

    @Override
    public void saxEntryValue(ContentHandler contentHandler, FormQuestion question, FormEntry entry) throws SAXException {
        super.saxEntryValue(contentHandler, question, entry);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"additional-infos");
        String nameForForm = question.getNameForForm();
        AttributesImpl attr = new AttributesImpl();
        boolean hasOtherValue = this.hasOtherOption(question);
        attr.addCDATAAttribute(ATTRIBUTE_OTHER, String.valueOf(hasOtherValue));
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"values", (Attributes)attr);
        if (entry.hasValue(nameForForm)) {
            List<Object> values;
            List<Object> list = values = entry.isMultiple(nameForForm) ? Arrays.asList((Object[])entry.getValue(nameForForm)) : List.of(entry.getValue(nameForForm));
            if (!values.isEmpty()) {
                ChoiceSourceType type = (ChoiceSourceType)this._choiceSourceTypeExtensionPoint.getExtension((String)question.getValue(ATTRIBUTE_SOURCE_TYPE));
                try {
                    HashMap<String, Object> enumParam = new HashMap<String, Object>();
                    enumParam.put("question", (Object)question);
                    for (Object value : values) {
                        String valAsString = type.value2String(value);
                        AttributesImpl attrVal = new AttributesImpl();
                        attrVal.addCDATAAttribute("val", valAsString);
                        if (type instanceof ManualWithCostsSourceType) {
                            ManualWithCostsSourceType costType = (ManualWithCostsSourceType)type;
                            attrVal.addCDATAAttribute("cost", String.valueOf(costType.getEntryCost(valAsString, enumParam)));
                        }
                        XMLUtils.startElement((ContentHandler)contentHandler, (String)"value", (Attributes)attrVal);
                        ChoiceOption choiceOption = new ChoiceOption(value);
                        I18nizableText label = type.getEntry(choiceOption, enumParam);
                        if (label != null) {
                            label.toSAX(contentHandler, "label");
                        } else {
                            XMLUtils.createElement((ContentHandler)contentHandler, (String)"label", (String)type.value2String(value));
                        }
                        XMLUtils.endElement((ContentHandler)contentHandler, (String)"value");
                    }
                }
                catch (Exception e) {
                    this.getLogger().error("An error occurred while saxing addionnal infos of the select.", (Throwable)e);
                }
            }
        }
        if (hasOtherValue && entry.hasValue(OTHER_PREFIX_DATA_NAME + nameForForm)) {
            String value = (String)entry.getValue(OTHER_PREFIX_DATA_NAME + nameForForm);
            AttributesImpl attrVal = new AttributesImpl();
            attrVal.addCDATAAttribute("val", value);
            attrVal.addCDATAAttribute("isOther", "true");
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"value", (Attributes)attrVal);
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"label", (String)value);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"val");
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"values");
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"additional-infos");
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add(ATTRIBUTE_SOURCE_TYPE);
        fieldNames.add("multiple");
        fieldNames.add(ATTRIBUTE_OTHER);
        ChoiceSourceType sourceType = this.getSourceType(question);
        if (sourceType != null) {
            for (String fieldName : sourceType.getFieldToDisableIfFormPublished()) {
                fieldNames.add(fieldName);
            }
        }
        return fieldNames;
    }

    @Override
    public void validateQuestionValues(Map<String, Object> values, Map<String, I18nizableText> errors) {
        super.validateQuestionValues(values, errors);
        String format = (String)values.get(ATTRIBUTE_FORMAT);
        String sourceTypeId = (String)values.get(ATTRIBUTE_SOURCE_TYPE);
        ChoiceSourceType sourceType = (ChoiceSourceType)this._choiceSourceTypeExtensionPoint.getExtension(sourceTypeId);
        if (sourceType.remoteData() && CHECKBOX_FORMAT_VALUE.equals(format)) {
            errors.put(ATTRIBUTE_FORMAT, new I18nizableText("plugin.forms", "PLUGINS_FORMS_CHOICE_LIST_INCOMPATIBLE_ERROR"));
        }
    }

    @Override
    public Validator getMandatoryValidator(FormQuestion question) {
        if (this.hasOtherOption(question)) {
            return null;
        }
        return super.getMandatoryValidator(question);
    }

    @Override
    public void validateEntryValues(FormQuestion question, Map<String, Object> values, Multimap<String, I18nizableText> errors, Optional<Long> currentStepId, Map<String, Object> additionalParameters) {
        super.validateEntryValues(question, values, errors, currentStepId, additionalParameters);
        if (question.isMandatory() && this.hasOtherOption(question)) {
            String nameForForm = question.getNameForForm();
            Object listValue = values.get(nameForForm);
            String otherValue = (String)values.get(OTHER_PREFIX_DATA_NAME + nameForForm);
            if (listValue == null && StringUtils.isBlank((CharSequence)otherValue)) {
                errors.put((Object)nameForForm, (Object)new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_DEFAULT_VALIDATOR_MANDATORY"));
            }
        }
    }

    public ModelItem getOtherFieldModel(FormQuestion question) {
        if (this.hasOtherOption(question)) {
            return this._formElementDefinitionHelper.getElementDefinition(OTHER_PREFIX_DATA_NAME + question.getNameForForm(), "string", null, null, null);
        }
        return null;
    }

    public boolean hasOtherOption(FormQuestion question) {
        return (Boolean)question.getValue(ATTRIBUTE_OTHER, false, false);
    }

    @Override
    public String getJSRenderer(FormQuestion question) {
        ChoiceSourceType sourceType = this.getSourceType(question);
        return sourceType.getJSRenderer();
    }

    @Override
    public String getJSConverter(FormQuestion question) {
        ChoiceSourceType sourceType = this.getSourceType(question);
        return sourceType.getJSConverter();
    }

    @Override
    public Object valueToJSONForClient(Object value, FormQuestion question, FormEntry entry, ModelItem modelItem) throws Exception {
        Object valueToJSONForClient = super.valueToJSONForClient(value, question, entry, modelItem);
        ChoiceSourceType sourceType = this.getSourceType(question);
        return sourceType.valueToJSONForClient(valueToJSONForClient, question, entry, modelItem);
    }

    @Override
    public ModelItem getMultipleModelItem() {
        return this._formElementDefinitionHelper.getElementDefinition("multiple", "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_MULTIPLE", "PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_MULTIPLE_DESC", null);
    }

    @Override
    public ViewElement getMultipleViewElement(Model model) {
        ViewElement mandatory = new ViewElement();
        mandatory.setDefinition((ElementDefinition)model.getModelItem("multiple"));
        return mandatory;
    }

    @Override
    public boolean isMultiple(FormQuestion question) {
        return (Boolean)question.getValue("multiple", false, false);
    }

    @Override
    public Map<String, Object> getAnonymizedData(FormQuestion question) {
        if (this.hasOtherOption(question)) {
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put(question.getNameForForm(), null);
            result.put(OTHER_PREFIX_DATA_NAME + question.getNameForForm(), this.isMandatory(question) ? "anonymized" : null);
            return result;
        }
        ChoiceSourceType sourceType = this.getSourceType(question);
        return Collections.singletonMap(question.getNameForForm(), this.isMandatory(question) ? sourceType.getAnonimizedValue(question) : null);
    }
}

