/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.data.holder.DataHolderRelativeDisableCondition;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditions;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditionsHelper;
import org.ametys.plugins.forms.question.computing.ComputingType;
import org.ametys.plugins.forms.question.computing.ComputingTypeExtensionPoint;
import org.ametys.plugins.forms.question.types.AbstractStaticFormQuestionType;
import org.ametys.plugins.forms.question.types.ConfidentialAwareQuestionType;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemGroup;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ComputedQuestionType
extends AbstractStaticFormQuestionType
implements ConfidentialAwareQuestionType {
    public static final String ATTRIBUTE_COMPUTING_TYPE = "computing-type";
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_COMPUTED";
    private ComputingTypeExtensionPoint _computingTypeExtensionPoint;
    private DataHolderRelativeDisableConditionsHelper _disableConditionsHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._computingTypeExtensionPoint = (ComputingTypeExtensionPoint)((Object)manager.lookup(ComputingTypeExtensionPoint.ROLE));
        this._disableConditionsHelper = (DataHolderRelativeDisableConditionsHelper)manager.lookup(DataHolderRelativeDisableConditionsHelper.ROLE);
    }

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        ElementDefinition computingType = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_COMPUTING_TYPE, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTED_COMPUTING_TYPE", "PLUGINS_FORMS_QUESTIONS_DIALOG_COMPUTED_COMPUTING_TYPE_DESC", null);
        StaticEnumerator typesStaticEnumerator = new StaticEnumerator();
        for (ComputingType type : this._getAllComputingType()) {
            typesStaticEnumerator.add(type.getLabel(), (Object)type.getId());
            DataHolderRelativeDisableCondition condition = new DataHolderRelativeDisableCondition(ATTRIBUTE_COMPUTING_TYPE, DisableCondition.OPERATOR.NEQ, type.getId(), true, this._disableConditionsHelper);
            Map<String, ModelItem> typeModelItems = type.getModelItems();
            for (ModelItem item : typeModelItems.values()) {
                DisableConditions itemDisableConditions = item.getDisableConditions() != null ? item.getDisableConditions() : new DataHolderRelativeDisableConditions();
                itemDisableConditions.getConditions().add(condition);
                item.setDisableConditions(itemDisableConditions);
            }
            modelItems.addAll(typeModelItems.values());
        }
        computingType.setEnumerator((Enumerator)typesStaticEnumerator);
        modelItems.add((ModelItem)computingType);
        modelItems.add(this.getConfidentialityModelItem());
        return modelItems;
    }

    @Override
    protected List<ViewItemGroup> _getTabs(Form form) {
        return List.of(this._getMainTab(), this._getAdvancedTab(), this._getRulesTab());
    }

    protected SimpleViewItemGroup _getMainTab() {
        SimpleViewItemGroup fieldset = super._createMainTab();
        ViewElement computingCombobox = new ViewElement();
        computingCombobox.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_COMPUTING_TYPE));
        fieldset.addViewItem((ViewItem)computingCombobox);
        for (ComputingType type : this._getAllComputingType()) {
            if (type.getViewElements().isEmpty()) continue;
            fieldset.addViewItems(type.getViewElements());
        }
        return fieldset;
    }

    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._createAdvancedTab();
        ViewElement title = new ViewElement();
        title.setDefinition((ElementDefinition)this.getModel().getModelItem("title"));
        advancedFieldset.addViewItem((ViewItem)title);
        ViewElement nameForForms = new ViewElement();
        nameForForms.setDefinition((ElementDefinition)this.getModel().getModelItem("name-for-form"));
        advancedFieldset.addViewItem((ViewItem)nameForForms);
        advancedFieldset.addViewItem(this.getConfidentialityViewElement(this.getModel()));
        return advancedFieldset;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        ComputingType computingType = this.getComputingType(question);
        if (computingType != null) {
            return computingType.getStorageType(question);
        }
        return "string";
    }

    @Override
    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
        super.saxAdditionalInfos(contentHandler, question);
        for (ComputingType type : this._getAllComputingType()) {
            AttributesImpl attr = new AttributesImpl();
            String xslEnabled = StringUtils.isBlank((CharSequence)type.getXSLT()) ? "false" : "true";
            attr.addCDATAAttribute("xsl-enabled", xslEnabled);
            attr.addCDATAAttribute("id", type.getId());
            XMLUtils.createElement((ContentHandler)contentHandler, (String)ATTRIBUTE_COMPUTING_TYPE, (Attributes)attr);
        }
    }

    private List<ComputingType> _getAllComputingType() {
        ArrayList<ComputingType> computingTypes = new ArrayList<ComputingType>();
        for (String id : this._computingTypeExtensionPoint.getExtensionsIds()) {
            computingTypes.add((ComputingType)this._computingTypeExtensionPoint.getExtension(id));
        }
        return computingTypes;
    }

    @Override
    public boolean isQuestionConfigured(FormQuestion question) {
        return StringUtils.isNotBlank((CharSequence)((CharSequence)question.getValue(ATTRIBUTE_COMPUTING_TYPE)));
    }

    public ComputingType getComputingType(FormQuestion question) {
        String value = (String)question.getValue(ATTRIBUTE_COMPUTING_TYPE);
        return StringUtils.isNotBlank((CharSequence)value) ? (ComputingType)this._computingTypeExtensionPoint.getExtension(value) : null;
    }

    @Override
    public Set<String> getDisplayXSLTs() {
        HashSet<String> displayXSLTs = new HashSet<String>(super.getDisplayXSLTs());
        this._getAllComputingType().stream().map(ComputingType::getXSLT).filter(StringUtils::isNotBlank).forEach(displayXSLTs::add);
        return displayXSLTs;
    }

    @Override
    public boolean onlyForDisplay(FormQuestion question) {
        ComputingType computingType = this.getComputingType(question);
        if (computingType != null) {
            return !computingType.hasComputedValue();
        }
        return true;
    }

    @Override
    public boolean canBeAnsweredByUser(FormQuestion question) {
        return false;
    }

    @Override
    public I18nizableText getDefaultTitle() {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }

    @Override
    public void saxEntryValue(ContentHandler contentHandler, FormQuestion question, FormEntry entry) throws SAXException {
        super.saxEntryValue(contentHandler, question, entry);
        AttributesImpl attrs = new AttributesImpl();
        ComputingType computingType = this.getComputingType(question);
        attrs.addCDATAAttribute("computed-type", computingType.getId());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"additional-infos", (Attributes)attrs);
        computingType.saxAdditionalValue(contentHandler, question, entry);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"additional-infos");
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add(ATTRIBUTE_COMPUTING_TYPE);
        ComputingType computingType = this.getComputingType(question);
        if (computingType != null) {
            for (String fieldName : computingType.getFieldToDisableIfFormPublished()) {
                fieldNames.add(fieldName);
            }
        }
        return fieldNames;
    }

    @Override
    public String getJSRenderer(FormQuestion question) {
        ComputingType computingType = this.getComputingType(question);
        return computingType.getJSRenderer();
    }

    @Override
    public Object valueToJSONForClient(Object value, FormQuestion question, FormEntry entry, ModelItem modelItem) throws Exception {
        Object valueToJSONForClient = super.valueToJSONForClient(value, question, entry, modelItem);
        ComputingType computingType = this.getComputingType(question);
        return computingType.valueToJSONForClient(valueToJSONForClient, question, entry, modelItem);
    }

    @Override
    public boolean isCacheable(FormQuestion question) {
        return this.getComputingType(question) == null || this.getComputingType(question).isCacheable();
    }

    @Override
    public ModelItem getConfidentialityModelItem() {
        return this._formElementDefinitionHelper.getElementDefinition("confidentiality", "boolean", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_CONFIDENTIAL", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_CONFIDENTIAL_DESC", null);
    }

    @Override
    public ViewItem getConfidentialityViewElement(Model model) {
        ViewElement confidential = new ViewElement();
        confidential.setDefinition((ElementDefinition)model.getModelItem("confidentiality"));
        return confidential;
    }

    @Override
    public boolean isConfidential(FormQuestion formQuestion) {
        return (Boolean)formQuestion.getValue("confidentiality", false, false);
    }

    @Override
    public Map<String, Object> getAnonymizedData(FormQuestion question) {
        ComputingType computingType = this.getComputingType(question);
        return computingType.getAnonymizedData(question);
    }
}

