/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.question.types.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.cms.data.holder.DataHolderRelativeDisableCondition;
import org.ametys.cms.data.holder.DataHolderRelativeDisableConditions;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.forms.question.autofill.AutofillSource;
import org.ametys.plugins.forms.question.autofill.AutofillSourceExtensionPoint;
import org.ametys.plugins.forms.question.types.AbstractFormQuestionType;
import org.ametys.plugins.forms.question.types.AutocompleteAwareQuestionType;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SimpleTextQuestionType
extends AbstractFormQuestionType
implements AutocompleteAwareQuestionType {
    public static final String ATTRIBUTE_REGEXP = "regexp";
    public static final String ATTRIBUTE_CUSTOM_REGEX = "custom-regex";
    public static final String ATTRIBUTE_AUTOFILL_SOURCE = "autofill-source";
    public static final String EMPTY_REGEX_VALUE = " ";
    public static final String EMAIL_REGEX_VALUE = "email";
    public static final String PHONE_REGEX_VALUE = "phone";
    public static final String CUSTOM_REGEX_VALUE = "custom";
    public static final String ATTRIBUTE_PLACEHOLDER = "placeholder";
    public static final String DEFAULT_TITLE = "PLUGIN_FORMS_QUESTION_DEFAULT_TITLE_SIMPLE_TEXT";
    protected CurrentUserProvider _currentUserProvider;
    protected UserManager _userManager;
    protected AutofillSourceExtensionPoint _autoFillSourceExtensionPoint;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._autoFillSourceExtensionPoint = (AutofillSourceExtensionPoint)((Object)manager.lookup(AutofillSourceExtensionPoint.ROLE));
    }

    @Override
    protected List<ModelItem> _getModelItems() {
        List<ModelItem> modelItems = super._getModelItems();
        ElementDefinition placeholder = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_PLACEHOLDER, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_PLACEHOLDER", "PLUGINS_FORMS_QUESTIONS_DIALOG_QUESTION_PLACEHOLDER_DESC", null);
        modelItems.add((ModelItem)placeholder);
        ElementDefinition autofillSource = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_AUTOFILL_SOURCE, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_SOURCE", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_SOURCE_DESC", null);
        StaticEnumerator sourcesStaticEnumerator = new StaticEnumerator();
        sourcesStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_AUTOFILL_EMPTY_TEXT"), (Object)"");
        for (AutofillSource source : this._getAllAutoFillSources()) {
            sourcesStaticEnumerator.add(source.getLabel(), (Object)source.getId());
            DataHolderRelativeDisableCondition condition = new DataHolderRelativeDisableCondition(ATTRIBUTE_AUTOFILL_SOURCE, DisableCondition.OPERATOR.NEQ, source.getId(), true, this._disableConditionsHelper);
            Map<String, ModelItem> sourceModelItems = source.getModelItems();
            for (ModelItem item : sourceModelItems.values()) {
                DisableConditions itemDisableConditions = item.getDisableConditions() != null ? item.getDisableConditions() : new DataHolderRelativeDisableConditions();
                itemDisableConditions.getConditions().add(condition);
                item.setDisableConditions(itemDisableConditions);
            }
            modelItems.addAll(sourceModelItems.values());
        }
        autofillSource.setEnumerator((Enumerator)sourcesStaticEnumerator);
        autofillSource.setDefaultValue((Object)"");
        modelItems.add((ModelItem)autofillSource);
        ElementDefinition regexp = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_REGEXP, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_DESC", null);
        StaticEnumerator regexStaticEnumerator = new StaticEnumerator();
        regexStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_EMPTY_TEXT"), (Object)EMPTY_REGEX_VALUE);
        regexStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_EMAIL"), (Object)EMAIL_REGEX_VALUE);
        regexStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_PHONE"), (Object)PHONE_REGEX_VALUE);
        regexStaticEnumerator.add(new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_CUSTOM"), (Object)CUSTOM_REGEX_VALUE);
        regexp.setEnumerator((Enumerator)regexStaticEnumerator);
        HashMap<String, I18nizableText> regexpWidgetParameters = new HashMap<String, I18nizableText>();
        regexpWidgetParameters.put("naturalOrder", new I18nizableText("true"));
        regexp.setWidgetParameters(regexpWidgetParameters);
        regexp.setDefaultValue((Object)EMPTY_REGEX_VALUE);
        modelItems.add((ModelItem)regexp);
        ElementDefinition customRegex = this._formElementDefinitionHelper.getElementDefinition(ATTRIBUTE_CUSTOM_REGEX, "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_CUSTOM", "PLUGINS_FORMS_QUESTIONS_DIALOG_SIMPLE_TEXT_REGEXTYPE_CUSTOM_DESC", (Validator)new DefaultValidator("^\\/.+\\/[gi]*$", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_REGEXP_ERROR_DESCRIPTION"), false));
        DataHolderRelativeDisableConditions regexDisableConditions = new DataHolderRelativeDisableConditions();
        DataHolderRelativeDisableCondition regexCondition = new DataHolderRelativeDisableCondition(ATTRIBUTE_REGEXP, DisableCondition.OPERATOR.NEQ, CUSTOM_REGEX_VALUE, this._disableConditionsHelper);
        regexDisableConditions.getConditions().add(regexCondition);
        customRegex.setDisableConditions((DisableConditions)regexDisableConditions);
        modelItems.add((ModelItem)customRegex);
        modelItems.add(this.getAutocompleteModelItem(AutocompleteAwareQuestionType.InputType.TEXT));
        return modelItems;
    }

    @Override
    protected SimpleViewItemGroup _getAdvancedTab() {
        SimpleViewItemGroup advancedFieldset = super._getAdvancedTab();
        ViewElement placeholder = new ViewElement();
        placeholder.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_PLACEHOLDER));
        advancedFieldset.addViewItem((ViewItem)placeholder);
        ViewElement regexp = new ViewElement();
        regexp.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_REGEXP));
        advancedFieldset.addViewItem((ViewItem)regexp);
        ViewElement customRegex = new ViewElement();
        customRegex.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_CUSTOM_REGEX));
        advancedFieldset.addViewItem((ViewItem)customRegex);
        advancedFieldset.addViewItem((ViewItem)this.getAutocompleteViewElement(this.getModel()));
        ViewElement autofill = new ViewElement();
        autofill.setDefinition((ElementDefinition)this.getModel().getModelItem(ATTRIBUTE_AUTOFILL_SOURCE));
        advancedFieldset.addViewItem((ViewItem)autofill);
        for (AutofillSource source : this._getAllAutoFillSources()) {
            if (source.getViewElements().isEmpty()) continue;
            advancedFieldset.addViewItems(source.getViewElements());
        }
        return advancedFieldset;
    }

    @Override
    public String getStorageType(FormQuestion question) {
        return "string";
    }

    @Override
    protected ModelItem _getEntryModelItem(FormQuestion question) {
        ModelItem item = super._getEntryModelItem(question);
        ((ElementDefinition)item).setValidator((Validator)new DefaultValidator(this._getEntryRegExpPattern(question), this.isMandatory(question)));
        return item;
    }

    @Override
    public void saxAdditionalInfos(ContentHandler contentHandler, FormQuestion question) throws SAXException {
        String pattern;
        super.saxAdditionalInfos(contentHandler, question);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)question.getValue(ATTRIBUTE_AUTOFILL_SOURCE)))) {
            this._getAutoFillSource(question).saxAdditionalInfos(contentHandler, question);
        }
        if (StringUtils.isNotEmpty((CharSequence)(pattern = this._getRegExpPattern(question)))) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"pattern", (String)pattern);
        }
    }

    private AutofillSource _getAutoFillSource(FormQuestion question) {
        String value = (String)question.getValue(ATTRIBUTE_AUTOFILL_SOURCE);
        return StringUtils.isNotBlank((CharSequence)value) ? (AutofillSource)this._autoFillSourceExtensionPoint.getExtension(value) : null;
    }

    private List<AutofillSource> _getAllAutoFillSources() {
        ArrayList<AutofillSource> autoFillSources = new ArrayList<AutofillSource>();
        for (String id : this._autoFillSourceExtensionPoint.getExtensionsIds()) {
            autoFillSources.add((AutofillSource)this._autoFillSourceExtensionPoint.getExtension(id));
        }
        return autoFillSources;
    }

    protected String _getRegExpPattern(FormQuestion question) {
        String regexpType = (String)question.getValue(ATTRIBUTE_REGEXP);
        if (regexpType == null) {
            return null;
        }
        if (EMAIL_REGEX_VALUE.equals(regexpType)) {
            return "/^([a-zA-Z0-9_\\.\\-\\+])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$/";
        }
        if (PHONE_REGEX_VALUE.equals(regexpType)) {
            return "/^(\\+?\\(?[0-9]{1,3}\\)?([\\s]?)(\\(0\\))?|0)([\\s]?)([0-9\\-\\+\\s]{4,})+$/";
        }
        if (CUSTOM_REGEX_VALUE.equals(regexpType) && !"".equals(question.getValue(ATTRIBUTE_CUSTOM_REGEX))) {
            return (String)question.getValue(ATTRIBUTE_CUSTOM_REGEX);
        }
        return null;
    }

    protected String _getEntryRegExpPattern(FormQuestion question) {
        String regexpType = (String)question.getValue(ATTRIBUTE_REGEXP);
        if (regexpType == null) {
            return null;
        }
        if (EMAIL_REGEX_VALUE.equals(regexpType)) {
            return "^([a-zA-Z0-9_\\.\\-\\+])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$";
        }
        if (PHONE_REGEX_VALUE.equals(regexpType)) {
            return "^(\\+?\\(?[0-9]{1,3}\\)?([\\s]?)(\\(0\\))?|0)([\\s]?)([0-9\\-\\+\\s]{4,})+$";
        }
        if (CUSTOM_REGEX_VALUE.equals(regexpType) && !"".equals(question.getValue(ATTRIBUTE_CUSTOM_REGEX))) {
            String custom = (String)question.getValue(ATTRIBUTE_CUSTOM_REGEX);
            return custom.substring(1, custom.length() - 1);
        }
        return null;
    }

    @Override
    public void validateQuestionValues(Map<String, Object> values, Map<String, I18nizableText> errors) {
        super.validateQuestionValues(values, errors);
        if (StringUtils.isNotBlank((CharSequence)((String)values.get(ATTRIBUTE_CUSTOM_REGEX))) && !Pattern.matches("^\\/.+\\/[gi]*$", (CharSequence)values.get(ATTRIBUTE_CUSTOM_REGEX))) {
            errors.put(ATTRIBUTE_CUSTOM_REGEX, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_REGEXP_ERROR_DESCRIPTION"));
        }
    }

    @Override
    public I18nizableText getDefaultTitle() {
        return new I18nizableText("plugin.forms", DEFAULT_TITLE);
    }

    @Override
    public List<String> getFieldToDisableIfFormPublished(FormQuestion question) {
        List<String> fieldNames = super.getFieldToDisableIfFormPublished(question);
        fieldNames.add(ATTRIBUTE_REGEXP);
        fieldNames.add(ATTRIBUTE_CUSTOM_REGEX);
        return fieldNames;
    }

    @Override
    public boolean isCacheable(FormQuestion question) {
        AutofillSource source = this._getAutoFillSource(question);
        return source == null || source.isCacheable(question);
    }

    private Map<AutocompleteAwareQuestionType.AutocompleteOption, List<AutocompleteAwareQuestionType.InputType>> _getAutocompleteOptions() {
        HashMap<AutocompleteAwareQuestionType.AutocompleteOption, List<AutocompleteAwareQuestionType.InputType>> autocompleteOptions = new HashMap<AutocompleteAwareQuestionType.AutocompleteOption, List<AutocompleteAwareQuestionType.InputType>>();
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_FULLNAME")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("honorific-prefix", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_HONORIFIC_PREFIX")), List.of(AutocompleteAwareQuestionType.InputType.SELECT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("given-name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_GIVEN_NAME")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("family-name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_FAMILY_NAME")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption(EMAIL_REGEX_VALUE, new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_EMAIL")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("organization-title", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_ORGANIZATION_TITLE")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("organization", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_ORGANIZATION")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("street-address", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_STREET_ADDRESS")), List.of(AutocompleteAwareQuestionType.InputType.TEXT, AutocompleteAwareQuestionType.InputType.TEXTAREA));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("country-name", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_COUNTRY_NAME")), List.of(AutocompleteAwareQuestionType.InputType.TEXT, AutocompleteAwareQuestionType.InputType.SELECT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("postal-code", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_POSTAL_CODE")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("bday", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_BIRTHDAY")), List.of(AutocompleteAwareQuestionType.InputType.DATE));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("sex", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_SEX")), List.of(AutocompleteAwareQuestionType.InputType.SELECT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("tel", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_TEL")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        autocompleteOptions.put(new AutocompleteAwareQuestionType.AutocompleteOption("url", new I18nizableText("plugin.forms", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_URL")), List.of(AutocompleteAwareQuestionType.InputType.TEXT));
        return autocompleteOptions;
    }

    @Override
    public ModelItem getAutocompleteModelItem(AutocompleteAwareQuestionType.InputType inputType) {
        ElementDefinition autocomplete = this._formElementDefinitionHelper.getElementDefinition("autocomplete", "string", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_LABEL", "PLUGINS_FORMS_QUESTIONS_DIALOG_AUTOCOMPLETE_DESC", null);
        StaticEnumerator autocompleteStaticEnumerator = new StaticEnumerator();
        this._getAutocompleteOptions().entrySet().stream().filter(e -> ((List)e.getValue()).contains((Object)inputType)).forEach(e -> autocompleteStaticEnumerator.add(((AutocompleteAwareQuestionType.AutocompleteOption)e.getKey()).label(), (Object)((AutocompleteAwareQuestionType.AutocompleteOption)e.getKey()).value()));
        autocomplete.setEnumerator((Enumerator)autocompleteStaticEnumerator);
        return autocomplete;
    }

    @Override
    public ViewElement getAutocompleteViewElement(Model model) {
        ViewElement description = new ViewElement();
        description.setDefinition((ElementDefinition)model.getModelItem("autocomplete"));
        return description;
    }

    @Override
    public String getAutocomplete(FormQuestion question) {
        return (String)question.getValue("autocomplete");
    }

    @Override
    public Map<String, Object> getAnonymizedData(FormQuestion question) {
        return Collections.singletonMap(question.getNameForForm(), this.isMandatory(question) ? "anonymized" : null);
    }
}

