/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.repository.type;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.model.type.AbstractElementType;
import org.ametys.plugins.forms.repository.type.Matrix;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.RepositoryElementType;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MatrixElementType
extends AbstractElementType<Matrix>
implements RepositoryElementType<Matrix> {
    public static final String MATRIX_DATA_TYPE = "matrix";

    public String getRepositoryDataType() {
        return "string";
    }

    public Matrix convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this._string2Matrix((String)value);
        }
        if (value instanceof Map) {
            Map castMap = (Map)value;
            return new Matrix(castMap);
        }
        throw new BadItemTypeException("Try to convert the non " + this.getId() + " JSON object '" + String.valueOf(value) + "' into a " + this.getId());
    }

    public String toString(Matrix value) {
        return this._jsonUtils.convertObjectToJson((Object)value);
    }

    public boolean isSimple() {
        return false;
    }

    public boolean isCompatible(Object value) {
        return super.isCompatible(value) || value instanceof String || value instanceof String[] || value instanceof Matrix || value instanceof Matrix[];
    }

    protected Matrix _string2Matrix(String value) {
        Map castMap = this._jsonUtils.convertJsonToMap(value).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (List)e.getValue(), (e1, e2) -> e1, LinkedHashMap::new));
        return new Matrix(castMap);
    }

    protected void _singleTypedNotEnumeratedValueToSAX(ContentHandler contentHandler, String tagName, Matrix value, DataContext context, AttributesImpl attributes) throws SAXException {
        AttributesImpl localAttributes = new AttributesImpl((Attributes)attributes);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)tagName, (Attributes)localAttributes);
        for (Map.Entry lineValue : value.entrySet()) {
            AttributesImpl optAttr = new AttributesImpl();
            optAttr.addCDATAAttribute("value", (String)lineValue.getKey());
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"option", (Attributes)optAttr);
            List colValues = (List)lineValue.getValue();
            for (String colValue : colValues) {
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"value", (String)colValue);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"option");
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)tagName);
    }

    public Object read(RepositoryData parentData, String name) throws BadItemTypeException {
        if (!parentData.hasValue(name)) {
            return null;
        }
        if (!this.isCompatible(parentData, name)) {
            throw new BadItemTypeException("Try to get " + this.getId() + " value from the non " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'");
        }
        if (parentData.isMultiple(name)) {
            String[] values = parentData.getStrings(name);
            return Arrays.stream(values).map(this::_string2Matrix).toArray(Matrix[]::new);
        }
        String value = parentData.getString(name);
        return this._string2Matrix(value);
    }

    public boolean hasNonEmptyValue(RepositoryData parentData, String name) throws BadItemTypeException {
        if (!parentData.hasValue(name)) {
            return false;
        }
        if (!this.isCompatible(parentData, name)) {
            throw new BadItemTypeException("Try to check matrix value from the non " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'");
        }
        if (parentData.isMultiple(name)) {
            return parentData.getStrings(name).length > 0;
        }
        return StringUtils.isNotEmpty((CharSequence)parentData.getString(name));
    }

    public void write(ModifiableRepositoryData parentData, String name, Object value) throws BadItemTypeException {
        if (value == null) {
            if (parentData.hasValue(name) && parentData.isMultiple(name)) {
                parentData.setValues(name, new String[0]);
            } else {
                parentData.setValue(name, "");
            }
        } else if (value instanceof String) {
            parentData.setValue(name, (String)value);
        } else if (value instanceof String[]) {
            Arrays.stream((String[])value).forEach(v -> Optional.ofNullable(v).orElseThrow(() -> new IllegalArgumentException("Try to set a null value into the multiple " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'")));
            parentData.setValues(name, (String[])value);
        } else if (value instanceof Matrix) {
            Matrix matrix = (Matrix)value;
            parentData.setValue(name, this._jsonUtils.convertObjectToJson((Object)matrix));
        } else if (value instanceof Matrix[]) {
            String[] values = (String[])Stream.of((Matrix[])value).map(m -> this._jsonUtils.convertObjectToJson(m)).toArray(String[]::new);
            parentData.setValues(name, values);
        } else if (value instanceof List) {
            List matrixList = (List)value;
            String[] matrixListAsJson = (String[])matrixList.stream().map(m -> this._jsonUtils.convertObjectToJson(m)).toArray(String[]::new);
            parentData.setValues(name, matrixListAsJson);
        } else {
            throw new BadItemTypeException("Try to set the non " + this.getId() + " value '" + String.valueOf(value) + "' to the " + this.getId() + " data '" + name + "' on '" + String.valueOf(parentData) + "'");
        }
    }
}

