/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.rights;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightsException;
import org.ametys.plugins.core.impl.right.AbstractHierarchicalAccessController;
import org.ametys.plugins.forms.dao.FormDirectoryDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormDirectory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class FormAccessController
extends AbstractHierarchicalAccessController<AmetysObject>
implements Contextualizable {
    public static final I18nizableText FORM_CONTEXT_CATEGORY = new I18nizableText("plugin.forms", "PLUGINS_FORMS_RIGHTS_CATEGORY");
    protected FormDirectoryDAO _formDirectoryDAO;
    private Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._formDirectoryDAO = (FormDirectoryDAO)((Object)manager.lookup(FormDirectoryDAO.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean supports(Object object) {
        return object instanceof Form || object instanceof FormDirectory;
    }

    protected Set<AmetysObject> _getParents(AmetysObject object) {
        AmetysObject parent = object.getParent();
        if (this.supports(parent)) {
            return Collections.singleton(parent);
        }
        return null;
    }

    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = WebHelper.getSiteName((Request)request);
        if (StringUtils.isNotBlank((CharSequence)siteName) && workspacesContexts.contains("/cms")) {
            return Collections.singleton(this._formDirectoryDAO.getFormDirectoriesRootNode(siteName));
        }
        return null;
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        if (object instanceof Form) {
            Map<String, I18nizableText> params = Map.of("title", this.getObjectLabel(object));
            return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ACCESS_CONTROLLER_FORM_CONTEXT_EXPLANATION_LABEL", params);
        }
        if (object instanceof FormDirectory) {
            Request request = ContextHelper.getRequest((Context)this._context);
            String siteName = WebHelper.getSiteName((Request)request);
            if (this._formDirectoryDAO.getFormDirectoriesRootNode(siteName).equals(object)) {
                return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ACCESS_CONTROLLER_ROOT_CONTEXT_EXPLANATION_LABEL");
            }
            Map<String, I18nizableText> params = Map.of("title", this.getObjectLabel(object));
            return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ACCESS_CONTROLLER_DIRECTORY_CONTEXT_EXPLANATION_LABEL", params);
        }
        throw new RightsException("Unsupported context " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Form) {
            Form form = (Form)((Object)object);
            return new I18nizableText(FormAccessController.getFormDirectoryPathLabel((FormDirectory)form.getParent()) + form.getTitle());
        }
        if (object instanceof FormDirectory) {
            FormDirectory directory = (FormDirectory)((Object)object);
            Request request = ContextHelper.getRequest((Context)this._context);
            String siteName = WebHelper.getSiteName((Request)request);
            if (this._formDirectoryDAO.getFormDirectoriesRootNode(siteName).equals(object)) {
                return new I18nizableText("plugin.forms", "PLUGINS_FORMS_ACCESS_CONTROLLER_ROOT_CONTEXT_LABEL");
            }
            return new I18nizableText(FormAccessController.getFormDirectoryPathLabel((FormDirectory)directory.getParent()) + directory.getTitle());
        }
        throw new RightsException("Unsupported context " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return FORM_CONTEXT_CATEGORY;
    }

    public int getObjectPriority(Object object) {
        Request request;
        String siteName;
        if (object instanceof FormDirectory && this._formDirectoryDAO.getFormDirectoriesRootNode(siteName = WebHelper.getSiteName((Request)(request = ContextHelper.getRequest((Context)this._context)))).equals(object)) {
            return 10;
        }
        return super.getObjectPriority(object);
    }

    public static String getFormDirectoryPathLabel(FormDirectory directory) {
        AmetysObject ametysObject = directory.getParent();
        if (ametysObject instanceof FormDirectory) {
            FormDirectory parent = (FormDirectory)ametysObject;
            return FormAccessController.getFormDirectoryPathLabel(parent) + directory.getTitle() + " > ";
        }
        return "";
    }
}

