/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import java.io.IOException;
import org.ametys.core.ui.RibbonControlsManager;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractFormEntriesWorkflowsGenerator
extends ServiceableGenerator {
    private static final String __FORM_WORKFLOW_TAB_EXTENSION_ID = "form-workflow-tab";
    protected WorkflowHelper _workflowHelper;
    protected RibbonControlsManager _ribbonControlsManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._workflowHelper = (WorkflowHelper)serviceManager.lookup(WorkflowHelper.ROLE);
        this._ribbonControlsManager = (RibbonControlsManager)serviceManager.lookup(RibbonControlsManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String[] formWorkflowNames = this._workflowHelper.getWorkflowNames();
        this.contentHandler.startDocument();
        AttributesImpl rootAttrs = new AttributesImpl();
        rootAttrs.addCDATAAttribute("tabLabelKey", this._getRibbonTabKeyToOverride());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"root", (Attributes)rootAttrs);
        AttributesImpl workflowTabAtts = new AttributesImpl();
        workflowTabAtts.addCDATAAttribute("tabId", __FORM_WORKFLOW_TAB_EXTENSION_ID);
        AttributesImpl groupAtts = new AttributesImpl();
        groupAtts.addCDATAAttribute("label", "plugin.forms:RIBBON_TABS_TAB_FORM_ENTRY_WORKFLOW_LABEL");
        groupAtts.addCDATAAttribute("order", "2");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"workflow-tab", (Attributes)workflowTabAtts);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"group", (Attributes)groupAtts);
        for (String workflowName : formWorkflowNames) {
            AttributesImpl attrs;
            if (!workflowName.startsWith(this._getPrefixWorkflowName())) continue;
            String defaultWorkflowButtonsId = this._getDefaultWorkflowButtonsId();
            String id = this._getPrefixWorkflowButton() + workflowName;
            if (this._ribbonControlsManager.hasExtension(id)) {
                attrs = new AttributesImpl();
                attrs.addCDATAAttribute("id", id);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"control", (Attributes)attrs);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)defaultWorkflowButtonsId)) continue;
            attrs = new AttributesImpl();
            attrs.addCDATAAttribute("ref-id", defaultWorkflowButtonsId);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"control", (Attributes)attrs);
            AttributesImpl workflowAttrs = new AttributesImpl();
            workflowAttrs.addCDATAAttribute("name", workflowName);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"workflow", (Attributes)workflowAttrs);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"control");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"group");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"workflow-tab");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"root");
        this.contentHandler.endDocument();
    }

    protected abstract String _getPrefixWorkflowName();

    protected abstract String _getPrefixWorkflowButton();

    protected abstract String _getDefaultWorkflowButtonsId();

    protected abstract String _getRibbonTabKeyToOverride();
}

