/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.forms.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class SendMailFunction
extends AbstractLogEnabled
implements Component,
EnhancedFunction {
    public static final String SEND_MAIL = "send-request-information-mail";
    public static final String SENDER = "sender";
    public static final String RECIPIENT = "recipient";
    public static final String SUBJECT = "subject";
    public static final String BODY = "body";

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        boolean dontSendMail = "false".equals(transientVars.get(SEND_MAIL));
        if (dontSendMail) {
            return;
        }
        String sender = (String)transientVars.get(SENDER);
        String recipient = (String)transientVars.get(RECIPIENT);
        String subject = (String)transientVars.get(SUBJECT);
        String body = (String)transientVars.get(BODY);
        try {
            String htmlBody = StandardMailBodyHelper.newHTMLBody().withTitle(subject).withMessage(body.replaceAll("\n\r", "<br/>")).build();
            SendMailHelper.newMail().withAsync(true).withSubject(subject).withHTMLBody(htmlBody).withSender(sender).withRecipient(recipient).sendMail();
        }
        catch (MessagingException | IOException e) {
            this.getLogger().warn("Could not send a workflow notification mail to " + recipient, e);
        }
    }

    public EnhancedFunction.FunctionType getFunctionExecType() {
        return EnhancedFunction.FunctionType.POST;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_SEND_MAIL_FUNCTION_LABEL");
    }

    public I18nizableText getFullLabel(Map<String, String> argumentsValues) {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_SEND_MAIL_FUNCTION_DESCRIPTION");
    }

    public List<WorkflowHelper.WorkflowVisibility> getVisibilities() {
        List visibilities = super.getVisibilities();
        visibilities.add(WorkflowHelper.WorkflowVisibility.USER);
        return visibilities;
    }
}

