<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service://pages/services/common/dashboard.xsl"/>
    
    <xsl:param name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">form-dashboard</xsl:variable>
    <xsl:variable name="cssPrefix">form-dashboard</xsl:variable>
    
    <xsl:variable name="is-empty" select="count(answers/answer) = 0"/> 
    <xsl:variable name="common-service-name">form-dashboard</xsl:variable>    
    <xsl:variable name="get-entry-fields-url">/content/dashboard/form-entry/view.html</xsl:variable>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="dashboard-js"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-empty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <div class="no-data">
                <xsl:choose>
                    <xsl:when test="/no-user-connected">
                        <p><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_NO_USER_CONNECTED" i18n:catalogue="plugin.forms"/></p>
                    </xsl:when>
                    <xsl:otherwise>
                        <p><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_NO_ENTRY" i18n:catalogue="plugin.forms"/></p>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$service-title"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="dashboard" />
    </xsl:template>
    
    <xsl:template name="dashboard-initialize-js">
        <script type="text/javascript">
        $j().ready(function() {
            DashboardHelper.initializeContentForms("<xsl:value-of select="$uniqueId" />", {
                siteName: "<xsl:value-of select="$site"/>",
                lang: "<xsl:value-of select="$lang"/>",
                contextPath: "<xsl:value-of select="$site-uri-prefix"/>",
                entryUrl: "<xsl:value-of select="$get-entry-fields-url"/>",
                onShowEntry: onShowEntry_<xsl:value-of select="$uniqueId" />,
                onShowHistory: onShowHistory_<xsl:value-of select="$uniqueId" />,
                onShowError: onShowError_<xsl:value-of select="$uniqueId" />,
                zoneItemId: "<xsl:value-of select="ametys:zoneItemId()" />"
            });
        });
        </script>
    </xsl:template>
        
</xsl:stylesheet>
