<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="exsl resolver ametys project">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service:forms://stylesheets/form2html.xsl"/>
    
    <xsl:param name="preview"><xsl:value-of select="/xml/form/@isPreview"/></xsl:param>
    <xsl:param name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:param name="redirectPageId" select="string(ametys:serviceParameter('redirectPageId')/text())"/>
    <xsl:param name="otherPage" select="ametys:serviceParameter('otherPage') = 'true'"/>
    <xsl:param name="redirectMode" select="string(ametys:serviceParameter('redirectMode')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">forms</xsl:variable>
    <xsl:variable name="is-empty" select="false()" /><!-- select=""/>   -->
    <xsl:variable name="common-service-name-id">service-forms</xsl:variable>   
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="form/title/text()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="head-scripts"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
        <xsl:call-template name="head-css"/>
        <xsl:call-template name="common-service-head-other-css"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-other-css"/>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:variable name="title">
            <xsl:choose>
                <xsl:when test="$preview = 'true'"><xsl:value-of select="form/title/text()"/></xsl:when>
                <xsl:when test="$service-title != ''"><xsl:value-of select="$service-title"/></xsl:when>
                <xsl:otherwise></xsl:otherwise>    
            </xsl:choose>
        </xsl:variable>
        <xsl:if test="$title !=  ''">
	        <xsl:call-template name="common-service-body-nonempty-content-title-content">
	            <xsl:with-param name="title" select="$title"/>
	        </xsl:call-template>    
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-service-body-nonempty-content-title" />
        </xsl:variable>
        <xsl:variable name="is-title-visible" select="string-length($raw-is-title-visible) &gt; 0"/>
       
        <xsl:call-template name="view">
            <xsl:with-param name="level">
                <xsl:choose>
                    <xsl:when test="$is-title-visible">2</xsl:when>
                    <xsl:otherwise>1</xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>
