<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:math="java.lang.Math" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              extension-element-prefixes="math ametys resolver">

    <xsl:import href="view://stylesheets/forms/questions/common/common-questions.xsl"/>
    <xsl:import href="formQuestion://formQuestion2html.xsl"/>

    <xsl:variable name="site-uri-prefix" select="ametys:siteUriPrefix()"/>
    
    <xsl:param name="preview">false</xsl:param>
    <xsl:param name="contextPath"/>
    <xsl:param name="uniqueId"/>
    <xsl:param name="lang"/>
    <xsl:param name="isSubmitter"/>
    
    
    <xsl:template match="/entry">
        <html>
            <head>
                <xsl:call-template name="head"/>
            </head>
            <body id="default">
                <xsl:call-template name="body"/>
            </body>
        </html>   
    </xsl:template>
    
    <xsl:template name="head">
        <xsl:call-template name="head-js-jquery" />
        <xsl:call-template name="head-css-jquery" />
        
        <xsl:call-template name="head-js-custom" />
        <xsl:call-template name="head-css-custom" />
        
        <xsl:call-template name="form-header" />
    </xsl:template>
    
    <xsl:template name="head-js-jquery">
        <script src="{ametys:pluginResourceURL('jquery', 'js/jquery.js')}" type="text/javascript"></script>
        <script src="{ametys:pluginResourceURL('jquery-ui', 'js/jquery-ui.js')}" type="text/javascript"></script>
        <xsl:if test="$lang != 'en'">
            <script src="{ametys:pluginResourceURL('jquery-ui', concat('js/i18n/datepicker-', $lang, '.js'))}" type="text/javascript"></script>
        </xsl:if>
        <script type="text/javascript">
            $j = jQuery.noConflict();
        </script>
    </xsl:template>
    
    <xsl:template name="head-css-jquery">
        <link type="text/css" href="{ametys:pluginResourceURL('jquery-ui', 'css/ui-lightness/jquery-ui.css')}" rel="stylesheet" />
    </xsl:template>
    
    <xsl:template name="head-js-custom"/>
    <xsl:template name="head-css-custom"/>
        
    <xsl:template name="form-header">
        <link rel="stylesheet" href="{ametys:pluginResourceURL('forms', 'vendor/css/select2/select2.css')}"/>
        
        <script type="text/javascript">
            function showSuccess_<xsl:value-of select="$uniqueId"/>()
            {
                var id = "<xsl:value-of select="$uniqueId" />";
                AmetysFormsHelper.stopRefreshing(id, 0);
                
                if (window.parent.DashboardHelper)
                {
                    window.parent.DashboardHelper.doAction(id, "<xsl:value-of select="@formId" />", "<xsl:value-of select="@id" />", "<xsl:value-of select="@actionId" />");
                }
            }
            
            function showErrors_<xsl:value-of select="$uniqueId"/>(errors)
            {
                var id = "<xsl:value-of select="$uniqueId" />";
                for (var i in errors)
                {
                    if (errors[i].name)
                    {
                        AmetysFormsHelper.addFormError(id, errors[i].name + "_" + id, errors[i].label, errors[i].message);
                    }
                    else
                    {
                        AmetysFormsHelper.addGlobalFormError(id, errors[i].message);
                    }
                }
                AmetysFormsHelper._showFormErrors(id, 0);
                
                AmetysFormsHelper.stopRefreshing(id, 0);
            }
        
            function checkForm_<xsl:value-of select="$uniqueId"/>_0()
            {
                AmetysFormsHelper.resetFormErrors('<xsl:value-of select="$uniqueId"/>');
            
                <xsl:apply-templates select="question[@canWrite = 'true' and mandatory = 'true']" mode="check-mandatory"/>

                <xsl:apply-templates select="question[@canWrite = 'true' and regexp and regexp/@value != ' ']" mode="check-regexp"/>
            
                <xsl:apply-templates select="question[@canWrite = 'true']" mode="check-values"/>
            }
        
            // Init the question values
            <xsl:apply-templates select="question" mode="init-values"/>
        
            // Set the rules
            <xsl:apply-templates select="question" mode="init-rules"/>
        
            $j( document ).ready(function() {
                // Js to render field
                <xsl:apply-templates select="question" mode="display-fn" />
            });
        </script>
        
        <script src="{$uri-prefix}/plugins/forms/resources/js/FormListenersHelper.{$lang}.js" type="text/javascript"/>
        <script src="{$uri-prefix}/plugins/forms/resources/js/AmetysFormsHelper.{$lang}.js" type="text/javascript"/>
        
        <script src="{ametys:pluginResourceURL('forms', 'vendor/js/select2/select2.js')}" type="text/javascript"/>
        <xsl:variable name="langUrl">vendor/js/select2/i18n/<xsl:value-of select="ametys:translate('plugin.forms:PLUGINS_FORMS_QUESTIONS_DIALOG_CHOICE_SELECT2_IMPORT_LANG', ametys:lang())" />.js</xsl:variable>
        <script src="{ametys:pluginResourceURL('forms', $langUrl)}" type="text/javascript"/>
    </xsl:template>
    
    <xsl:template name="body">
        <div class="ametys-cms-service forms" id="form-{$uniqueId}">
            <form id="form-{$uniqueId}-form" class="form" method="post" action="{$site-uri-prefix}/_plugins/forms/{$lang}/edit/{$uniqueId}" data-ametys-form="true">
                <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
                <div>
                    <div id="form-{$uniqueId}-page-0">
                        <input type="hidden" name="entryId" value="{@id}"/>
                        <input type="hidden" name="isSubmitter" value="{$isSubmitter}"/>
                    
                        <xsl:apply-templates select="question"/>
                    
                        <!-- Submit button -->
                        <xsl:call-template name="common-utils-input-submit">
                            <xsl:with-param name="id">submit-<xsl:value-of select="$uniqueId"/></xsl:with-param>
                            <xsl:with-param name="class-name">submit</xsl:with-param>
                            <xsl:with-param name="i18nkey">PLUGINS_FORMS_PAGE_FORM_FINISH_BUTTON</xsl:with-param>
                            <xsl:with-param name="onclick">AmetysFormsHelper.endForm('<xsl:value-of select="$uniqueId" />', 0); return false;</xsl:with-param>
                        </xsl:call-template>
                        <script>
                            $j('#submit-<xsl:value-of select="$uniqueId"/>').hide();
                        </script>
                    </div>
                </div>
            </form>
        </div>
    </xsl:template>
    
</xsl:stylesheet>