/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a a form directory.
 * @private
 */
Ext.define("Ametys.plugins.forms.FormDirectory", 
	{
		config: {
			/**
			 * @cfg {String} id The unique id of the form directory
			 */
			/**
			 * @method getId Get the #cfg-id
			 * @return {String} The id
			 */
			/** @ignore */
			id: null,
			/**
			 * @cfg {String} title The title of the form directory
			 */
			/**
			 * @method getTitle Get the #cfg-title
			 * @return {String} The title
			 */
			/** @ignore */
			title: null,
			/**
             * @cfg {String} fullPath The full path of the form directory
             */
            /**
             * @method getFullPath Get the #cfg-fullPath
             * @return {String} The full path
             */
            /** @ignore */
            fullPath: null,
            /**
             * @cfg {String} parentId The form directory parent id
             */
            /**
             * @method getParentId Get the #cfg-parentId
             * @return {String} The form directory parent id
             */
            /** @ignore */
            parentId: null,
			/**
             * @cfg {String[]} rights List of the id of the rights the current user have on this form directory
             */
            /**
             * @method getRights Get the #cfg-rights
             * @return {String[]} The rights
             */
            /** @ignore */
            rights: [],
            /**
             * @cfg {Boolean} canWriteParent True if the user can write form directory parent
             */
            /**
             * @method getCanWriteParent Get the #cfg-canWriteParent
             * @return {Boolean} True if the user can write form directory parent
             */
            /** @ignore */
            canWriteParent: false,
            /**
             * @cfg {Boolean} canEditRight True if the user can edit form directory rights
             */
            /**
             * @method getCanEditRight Get the #cfg-canEditRight
             * @return {Boolean} True if the user can edit form directory rights
             */
            /** @ignore */
            canEditRight: false
		},
		
		
		/**
		 * Creates a content instance
		 * @param {Object} config See configuration doc.
		 */
		constructor: function (config)
		{
			this.initConfig(config);
		},
		
		/**
		 * Get the form directory's properties
		 * @return {Object} initialProperty The initial form directory's properties
		 */
		getProperties: function (initialProperty)
		{
            initialProperty = initialProperty || {};
            
            return Ext.apply ({
                    id: this._id,
                    title: this._title,
                    fullPath: this._fullPath,
                    parentId: this._parentId,
                    rights: this._rights,
                    canWriteParent: this._canWriteParent,
                    canEditRight: this._canEditRight
                }, initialProperty
            );
		},
		
		/**
         * True if the current user have the right to handle form directory
         * @return {Boolean} True if the current user have the right to handle form directory
         */
        canWrite: function()
        {
            return this._rights.indexOf("FormsDirectory_Rights_Directories") != -1;
        },
		
		/**
         * True if the current user have the right to rename form directory
         * @return {Boolean} True if the current user have the right to rename form directory
         */
        canRename: function()
        {
            return this.canWrite() && this._canWriteParent;
        }
	}
);
