/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a question.
 * @private
 */
Ext.define(
	"Ametys.plugins.forms.Question", 
	{
		config: {
			/**
			 * @cfg {String} id The unique id of the question
			 */
			/**
			 * @method getId Get the #cfg-id
			 * @return {String} The id
			 */
			/** @ignore */
			id: null,
			/**
			 * @cfg {String} title The title of the question
			 */
			/**
			 * @method getTitle Get the #cfg-title
			 * @return {String} The title
			 */
			/** @ignore */
			title: null,
			/**
             * @cfg {String} questionType The type of the question
             */
            /**
             * @method getQuestionType Get the #cfg-questionType
             * @return {String} The type of the question
             */
            /** @ignore */
            questionType: null,
            /**
             * @cfg {String} pageId The question page id
             */
            /**
             * @method getPageId Get the #cfg-pageId
             * @return {String} The question page id
             */
            /** @ignore */
            pageId: null,
            /**
             * @cfg {String} formId The question form id
             */
            /**
             * @method getFormId Get the #cfg-formId
             * @return {String} The question form id
             */
            /** @ignore */
            formId: null,
            /**
             * @cfg {String} iconGlyph The icon glyph of the question
             */
            /**
             * @method getIconGlyph Get the #cfg-iconGlyph
             * @return {String} The icon glyph of the question
             */
            /** @ignore */
            iconGlyph: null,
            /**
             * @cfg {String} typeLabel The label type of the question
             */
            /**
             * @method getTypeLabel Get the #cfg-typeLabel
             * @return {String} The label type of the question
             */
            /** @ignore */
            typeLabel: null,
            /**
             * @cfg {Boolean} hasEntries true if the question form has at least one entry
             */
            /**
             * @method getHasEntries Get the #cfg-hasEntries
             * @return {Boolean} true if the question form has at least one entry
             */
            /** @ignore */
            hasEntries: false,
            /**
             * @cfg {Boolean} hasRule true if the question has at least one rule
             */
            /**
             * @method getHasRule Get the #cfg-hasEntries
             * @return {Boolean} true if the question has at least one rule
             */
            /** @ignore */
            hasRule: false,
            /**
             * @cfg {Boolean} isConfigured True if the question is well configured
             */
            /**
             * @method getIsConfigured Get the #cfg-isConfigured
             * @return {Boolean} True if the question is well configured
             */
            /** @ignore */
            isConfigured: false,
            /**
             * @cfg {String[]} rights List of the id of the rights the current user have on this question
             */
            /**
             * @method getRights Get the #cfg-rights
             * @return {String[]} The rights
             */
            /** @ignore */
            rights: []
		},
		
		/**
		 * Creates a content instance
		 * @param {Object} config See configuration doc.
		 */
		constructor: function (config)
		{
			this.initConfig(config);
		},
		
		/**
		 * Get the question's properties
		 * @return {Object} The question's properties
		 */
		getProperties: function (initialProperty)
		{
			initialProperty = initialProperty || {};
			
			return Ext.apply ({
					id: this._id,
					title: this._title,
                    questionType: this._questionType,
                    pageId: this._pageId,
                    formId: this._formId,
                    iconGlyph: this._iconGlyph,
                    typeLabel: this._typeLabel,
                    hasEntries: this._hasEntries,
                    hasRule: this._hasRule,
                    isConfigured: this._isConfigured,
                    rights: this._rights
				}, initialProperty
			);
		}
	}
);