<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:docbook="http://docbook.org/ns/docbook"
	xmlns:html="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	exclude-result-prefixes="docbook xlink resolver html">

	<xsl:param name="contextPath" />
	<xsl:param name="workspaceName" />
	<xsl:param name="workspaceURI" />

	<xsl:template match="html:form">
		<form>
			<xsl:copy-of select="@*[not(@xmlns)]" />
			<xsl:apply-templates />
		</form>
	</xsl:template>

	<xsl:template match="html:label">
		<label>
			<xsl:copy-of select="@*[not(@xmlns)]" />
			<xsl:value-of select="." />
		</label>
	</xsl:template>

	<xsl:template match="html:input">
		<input>
			<xsl:copy-of select="@*[not(@xmlns)]" />
			<xsl:value-of select="." />
		</input>
	</xsl:template>

	<xsl:template match="html:textarea">
		<textarea>
			<xsl:copy-of select="@*[not(@xmlns)]" />
			<xsl:value-of select="." />
		</textarea>
	</xsl:template>

	<xsl:template match="html:select">
		<select>
			<xsl:copy-of select="@*[not(xmlns)]" />
			<xsl:apply-templates select="html:option" />
		</select>
	</xsl:template>

	<xsl:template match="html:option">
		<option>
			<xsl:copy-of select="@*[not(@xmlns)]" />
			<xsl:value-of select="." />
		</option>
	</xsl:template>

	<xsl:template match="html:fieldset">
		<xsl:element name="fieldset">
			<xsl:copy-of select="@*[not(@xmlns)]" />
			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>

	<xsl:template match="html:legend">
		<legend>
			<xsl:copy-of select="@*[not(@xmlns)]" />
			<xsl:value-of select="." />
		</legend>
	</xsl:template>
	
	<xsl:template match="html:captcha">
		<captcha>
			<xsl:copy-of select="@*[not(@xmlns)]" />
		</captcha>
	</xsl:template>
</xsl:stylesheet>