<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    exclude-result-prefixes="ametys resolver">

    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>

    <xsl:variable name="date-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_FORMAT', ametys:lang())"></xsl:variable>
    <xsl:variable name="date-time-format" select="ametys:translate('plugin.forms:PLUGINS_FORMS_SERVICE_DASHBOARD_DATE_TIME_FORMAT', ametys:lang())"></xsl:variable>
    
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
    <xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'"/>
    
    <xsl:template match="field[@type='file']" mode="value">
        <a href="{resolver:resolve('attribute', value/@uri, 'true')}"><xsl:value-of select="value/@filename" /></a>
    </xsl:template>
    
    <xsl:template match="field[@type='datetime']" mode="value">
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{value}"/>
    </xsl:template>
    
    <xsl:template match="field[@type='date']" mode="value">
        <i18n:date src-pattern="yyyy-MM-dd" pattern="{$date-format}" value="{value}"/>
    </xsl:template>
    
    <xsl:template match="field[@type='boolean']" mode="value">
        <xsl:choose>
            <xsl:when test="value = 'true'">
                <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_TRUE" i18n:catalogue="plugin.forms"/>
            </xsl:when>
            <xsl:otherwise> <i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ENTRY_BOOLEAN_FALSE" i18n:catalogue="plugin.forms"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@type='string']" mode="value">
        <xsl:call-template name="text.nl2br">
            <xsl:with-param name="input" select="value"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.ChoicesList']" mode="value">
        <xsl:choose>
            <xsl:when test="count(additional-infos/values/value) > 1">
                <ul>
                <xsl:for-each select="additional-infos/values/value">
                    <li>
	                    <xsl:variable name="value" select="." />
	                    <xsl:variable name="label" select="label" />
	                    <xsl:choose>
	                       <xsl:when test="$label != ''">
	                           <xsl:value-of select="$label" />
	                       </xsl:when>
	                       <xsl:otherwise>
	                           <xsl:value-of select="$value" />
	                       </xsl:otherwise>
	                    </xsl:choose>
                    </li>
                </xsl:for-each>
                </ul>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="value" select="additional-infos/values/value" />
                <xsl:variable name="label" select="additional-infos/values/value/label" />
               
                <xsl:choose>
                   <xsl:when test="$label != ''">
                       <xsl:value-of select="$label" />
                   </xsl:when>
                   <xsl:otherwise>
                       <xsl:value-of select="$value" />
                   </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="field[@typeId='form.Computed' and additional-infos/@computed-type = 'computing.CurrentPageId']" mode="value">
        <a target="blank" href="{resolver:resolve('page', additional-infos/page/id, false(), true())}"><xsl:value-of select="additional-infos/page/title"/></a>
    </xsl:template>
    
    <xsl:template match="field[@type='matrix']" mode="value">
        <ul>
            <xsl:for-each select="additional-infos/options/option">
                <xsl:variable name="optValue" select="@value"/> 
                <xsl:variable name="optLabel" select="@label"/> 
                <xsl:variable name="val">
                    <xsl:for-each select="../../../value/option[@value=$optValue]/value">
                        <xsl:variable name="colValue" select="."/>
                        <xsl:value-of select="../../../additional-infos/columns/column[@value= $colValue]"/>
                        <xsl:if test="position() != last()">, </xsl:if>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:if test="$val != ''">
                    <li>
                        <xsl:value-of select="$optLabel" />
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="$val" />
                    </li>
                </xsl:if>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template match="field" mode="value">
        <xsl:value-of select="value"/>
    </xsl:template>
    
</xsl:stylesheet>
