<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:math="java.lang.Math" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              extension-element-prefixes="math ametys resolver">
                              
    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    <xsl:import href="view://stylesheets/utils.xsl"/>
    <xsl:import href="view://stylesheets/forms/questions/common/common-questions.xsl"/>
    <xsl:import href="formQuestion://formQuestion2html.xsl"/>
    
    <xsl:param name="preview">false</xsl:param>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    <xsl:variable name="renderingContext" select="ametys:renderingContext()"/>
    
    <xsl:template match="/entry">
        <xsl:apply-templates select="question"  mode="render-mail"/>
    </xsl:template>
    
</xsl:stylesheet>