<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
							  xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" exclude-result-prefixes="docbook resolver i18n">
                              
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.forms.question.computing.User']" mode ="render-js">
		<xsl:param name="title"/>
		<xsl:param name="name"/>
        <xsl:param name="value"/>
		
        <!-- No computing if there is a value (entry edition) -->
        <xsl:if test="not($value)">
			$j(document).ready(function() {
				getAmetysUser(function(user){
				    var fdLabel = "<xsl:value-of select="$title"/>";
					var userInfo = '<xsl:value-of select="../../user-info/@value"/>';
					var fdValue = ""; 
					switch (userInfo)
					{
						case "email": 
							fdValue = user.email;
							break;
						case "id": 
							fdValue = user.login;
				            break;
						case "fullName": 
							fdValue = user.fullname;
							break;
						case "firstName": 
							fdValue = user.firstname; 
							break;
						case "lastName":
							fdValue = user.lastname; 
							break;
					}
                    
                    var $fd = $j('#' + '<xsl:value-of select="$name" />_<xsl:value-of select="$uniqueId" />');
                    $fd.find('[data-ametys-computed-label]').text(fdLabel);
                    $fd.find('[data-ametys-computed-value]').text(fdValue);
				});
			});
        </xsl:if>
	</xsl:template>
	
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.forms.question.computing.User']" mode="render-html">
		<xsl:param name="title"/>
		<xsl:param name="name"/>
        
		<div class="computed" id="{$name}_{$uniqueId}"> 
		  <p class="text">
            <span class="computed__label" data-ametys-computed-label=""></span><xsl:text>: </xsl:text> 
            <span class="computed__value" data-ametys-computed-value=""></span>
		  </p>
        </div>
	</xsl:template>
	
	<xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.forms.question.computing.User']" mode="read-only-render-html">
        <xsl:param name="title"/>
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        
        <div class="computed" id="{$name}_{$uniqueId}"> 
            <div class="label">
                <label for="{$name}_{$uniqueId}">
                    <xsl:value-of select="$title" />
                </label>
            </div>
            <div class="{$cssPrefix}__item_value">
                <p class="text">
                    <span class="computed__value" ><xsl:value-of select="$value" /></span>
                </p>
           </div>
        </div>
    </xsl:template>
    
    <xsl:template match="computing-type[@xsl-enabled = 'true' and @id = 'org.ametys.plugins.forms.question.computing.User']" mode ="render-mail">
        <xsl:param name="value"/>
        <xsl:value-of select="$value"/>
    </xsl:template>
</xsl:stylesheet>