<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                exclude-result-prefixes="i18n">
    
    <xsl:import href="plugin:cms://stylesheets/properties/technical/content/date.xsl"/>
    
    <xsl:template match="/ActionResult">
        <div class="bloc">
            <xsl:apply-templates select="*"/>
        </div>
    </xsl:template>
    
    <xsl:template match="*">
        <p>
            <strong><xsl:apply-templates select="." mode="title"/></strong>
            <xsl:text>&#160;</xsl:text>
            <span><xsl:apply-templates select="." mode="value"/></span>
        </p>
    </xsl:template>
    
    <xsl:template match="id" mode="title">
        <i18n:text i18n:catalogue="plugin.forms" i18n:key="UITOOL_DETAILS_FORM_ENTRY_ENTRY_ID"/>
    </xsl:template>
    
    <xsl:template match="submit" mode="title">
        <i18n:text i18n:catalogue="plugin.forms" i18n:key="UITOOL_DETAILS_FORM_ENTRY_SUBMIT_DATE"/>
    </xsl:template>
    
    <xsl:template match="submit" mode="value">
        <xsl:call-template name="render-date-and-user" />
    </xsl:template>
    
    <xsl:template match="*" mode="value">
        <xsl:value-of select="."/>
    </xsl:template>
</xsl:stylesheet>