/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.repository;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.forms.dao.FormEntryDAO;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.plugin.component.DeferredServiceable;

/**
 * {@link AmetysObjectFactory} for handling {@link FormEntry}s.
 */
public class FormEntryFactory extends SimpleAmetysObjectFactory implements DeferredServiceable
{
    /** JCR node type for form entry */
    public static final String NODE_TYPE = "ametys:form-entry";
    /** The form entry DAO */
    protected FormEntryDAO _formEntryDAO;
    
    @Override
    public void deferredService(ServiceManager manager) throws ServiceException
    {
        _formEntryDAO = (FormEntryDAO) manager.lookup(FormEntryDAO.ROLE);
    }
    
    @Override
    public FormEntry getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new FormEntry(node, parentPath, this);
    }
    
    /**
     * Get the form entry model
     * @param form the form
     * @return the form entry model
     */
    public Model getFormEntryModel(Form form)
    {
        return _formEntryDAO.getFormEntryModel(form);
    }
}
