/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.repository;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link AmetysObjectFactory} for handling {@link FormPageRule}s.
 */
public class FormPageRuleFactory extends SimpleAmetysObjectFactory
{
    @Override
    public FormPageRule getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new FormPageRule(node, parentPath, this);
    }
    
    /**
     * Get the form entry model
     * @return the form entry model
     * @throws AmetysRepositoryException if an error occurs.
     */
    public Model getFormRuleModel() throws AmetysRepositoryException
    {
        String role = ModelItemTypeExtensionPoint.ROLE_MODEL_AWARE_BASIC;
        
        try
        {
            return Model.of(
                "form.page.rule.model.id", 
                "form.page.rule.model.family.id",
                DefaultElementDefinition.of(FormPageRule.ATTRIBUTE_OPTION_VALUE, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                DefaultElementDefinition.of(FormPageRule.ATTRIBUTE_TARGET_ID, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                DefaultElementDefinition.of(FormPageRule.ATTRIBUTE_TYPE, false, ModelItemTypeConstants.STRING_TYPE_ID, role)
            );
        }
        catch (UnknownTypeException | BadItemTypeException | ServiceException e)
        {
            throw new AmetysRepositoryException("An error occurred while creating the Rule model", e);
        }
    }
}
