/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.workflow;

import java.util.List;
import java.util.Map;

import org.ametys.cms.workflow.AmetysObjectCheckRightsCondition;
import org.ametys.core.right.Right;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.plugins.workflow.support.WorkflowElementDefinitionHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper.WorkflowVisibility;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.model.StaticEnumerator;

/**
 * Worklow condition for checking rights on form entry
 */
public class FormCheckRightsCondition extends AmetysObjectCheckRightsCondition
{
    @SuppressWarnings("unchecked")
    @Override
    public List<WorkflowArgument> getArguments()
    {
        WorkflowArgument rights = WorkflowElementDefinitionHelper.getElementDefinition(
            __RIGHT_KEY,
            new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CHECK_RIGHTS_ARGUMENT_RIGHT_KEY_LABEL"),
            new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CHECK_RIGHTS_ARGUMENT_RIGHT_KEY_DESCRIPTION"),
            true,
            false
        );
        rights.setEnumerator(_getRightsEnumerator());
        
        return List.of(rights);
    }
    
    @Override
    protected StaticEnumerator _getRightsEnumerator()
    {
        StaticEnumerator<String> rightsStaticEnumerator = new StaticEnumerator<>();
        for (String rightId : _rightsExtensionPoint.getExtensionsIds())
        {
            Right right = _rightsExtensionPoint.getExtension(rightId);
            if (WorkflowFormSendMailFunction.FORMS_RIGHTS_CATEGORY.equals(right.getCategory().toString()))
            {
                Map<String, I18nizableTextParameter> params = Map.of("category", right.getCategory(), "label", right.getLabel());
                rightsStaticEnumerator.add(new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_CHECK_RIGHTS_ARGUMENT_RIGHT_KEY_PARAMS_LABEL", params), right.getId());
            }
        }
        
        return rightsStaticEnumerator;
    }
    
    @Override
    public List<WorkflowVisibility> getVisibilities()
    {
        List<WorkflowVisibility> visibilities = super.getVisibilities();
        visibilities.add(WorkflowVisibility.USER);
        return visibilities;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_EDITOR_EDITOR_CHECK_RIGHTS_CONDITION_LABEL");
    }
    
    @Override
    protected I18nizableText _getSingleConditionDescriptionKey(List<String> parameters)
    {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_EDITOR_EDITOR_CHECK_RIGHTS_CONDITION_DESCRIPTION", parameters);
    }
}
