/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.forms.workflow;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;

/**
 * OS workflow function to send mail if there is a comment after an action is triggered.
 */
public class WorkflowFormSendMailWithCommentFunction extends WorkflowFormSendMailFunction
{
    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException
    {
        String comment = _getStringParam(transientVars, ARG_COMMENT);
        // If the parameter send-if-comment is true, send the mail only if the comment is not blank
        if (StringUtils.isNotBlank(comment))
        {
            super.execute(transientVars, args, ps);
        }
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.forms", "PLUGINS_FORMS_WORKFLOW_FORM_SEND_MAIL_WITH_COMMENT_FUNCTION_LABEL");
    }
    
    @Override
    protected String _getFunctionArgumentPrefix()
    {
        return WorkflowFormSendMailWithCommentFunction.class.getName() + "-";
    }
}
