/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.googlecalendar;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ametys.core.util.URIUtils;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CalendarIframeGenerator
extends AbstractGenerator {
    private static final String __CALENDAR_SERVER_URL = "https://calendar.google.com/calendar/embed";
    private static final String __CTZ = "Europe/Paris";
    private static final String __DEFAULT_COLOR = "#2952A3";
    private static final String __DEFAULT_BGCOLOR = "#FFFFFF";
    private static final String __DEFAULT_HEIGHT = "600";
    private static final String __DEFAULT_MODE = "MONTH";
    private static final String __DOES_NOT_SHOW_PARAM = "0";
    private static final String __HEIGHT_PARAM = "height";

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("src", this._getSrcAttrValue());
        atts.addCDATAAttribute(__HEIGHT_PARAM, this._getParameterValue(__HEIGHT_PARAM, __DEFAULT_HEIGHT));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"iframe", (Attributes)atts);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"iframe");
        this.contentHandler.endDocument();
    }

    private String _getSrcAttrValue() {
        return this._buildURL(this._getParametersAsMap());
    }

    private String _buildURL(Map<String, String> urlParams) {
        StringBuilder builder = new StringBuilder(__CALENDAR_SERVER_URL);
        if (urlParams.size() > 0) {
            builder.append('?');
        }
        Iterator<Map.Entry<String, String>> entrySet = urlParams.entrySet().iterator();
        while (entrySet.hasNext()) {
            Map.Entry<String, String> entry = entrySet.next();
            builder.append(entry.getKey()).append('=').append(URIUtils.encodeParameter((String)entry.getValue()));
            if (!entrySet.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    private Map<String, String> _getParametersAsMap() {
        HashMap<String, String> urlParams = new HashMap<String, String>();
        for (String paramName : this.parameters.getNames()) {
            if (paramName.startsWith("show")) {
                boolean paramValue = this.parameters.getParameterAsBoolean(paramName, false);
                if (paramValue) continue;
                urlParams.put(paramName, __DOES_NOT_SHOW_PARAM);
                continue;
            }
            if ("mode".equals(paramName)) {
                String paramValue = this._getParameterValue(paramName, __DEFAULT_MODE);
                if (__DEFAULT_MODE.equals(paramValue)) continue;
                urlParams.put(paramName, paramValue);
                continue;
            }
            if ("bgcolor".equals(paramName)) {
                String paramValue = this._getParameterValue(paramName, __DEFAULT_BGCOLOR);
                urlParams.put(paramName, paramValue);
                continue;
            }
            if (!"wkst".equals(paramName) && !"src".equals(paramName)) continue;
            urlParams.put(paramName, this.parameters.getParameter(paramName, ""));
        }
        urlParams.put("ctz", __CTZ);
        urlParams.put("color", __DEFAULT_COLOR);
        return urlParams;
    }

    private String _getParameterValue(String name, String defaultValue) {
        String value = this.parameters.getParameter(name, defaultValue);
        if (value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }
}

