<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >    
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="gdpr:google-calendar"/>

    <xsl:param name="border" select="ametys:serviceParameter('iframe-border')/text()"/>
    <xsl:param name="header" select="string(ametys:serviceParameter('header')/text())"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">googlecalendar</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/> 
    <xsl:variable name="common-service-name-id">service-google-calendar</xsl:variable>    
    
    <xsl:variable name="height">
        <xsl:choose>
            <xsl:when test="/iframe/@height = ''">100%</xsl:when>
            <xsl:otherwise><xsl:value-of select="/iframe/@height"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                  
        </xsl:call-template>
    </xsl:template>  
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="google-calendar">
            <xsl:with-param name="title" select="$header" />
            <xsl:with-param name="height" select="$height" />
            <xsl:with-param name="border" select="$border" />
            <xsl:with-param name="src" select="@src" />
        </xsl:call-template>
    </xsl:template>  
      
</xsl:stylesheet>

