<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:template name="google-calendar" >
        <xsl:param name="title"/>
        <xsl:param name="height"/>
        <xsl:param name="border"/>
        <xsl:param name="src"/>
    
        <xsl:variable name="style">
            width: 100%;  height:<xsl:value-of select="$height"/>px;
        </xsl:variable>
    
        <iframe src="{@src}" scrolling="no" style="{$style}">
             <xsl:attribute name="frameborder"><xsl:choose><xsl:when test="$border = 'true'">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute>
             <p><i18n:text i18n:key="PLUGINS_GOOGLE_CALENDAR_SERVICE_IFRAME_NOT_SUPPORTED" i18n:catalogue="plugin.google-calendar"/><a href="{@src}" title="{$header}"><xsl:value-of select="@src"/></a></p>
        </iframe>
    </xsl:template>
    
</xsl:stylesheet>
