/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.googlecalendar;

import java.util.LinkedHashMap;
import java.util.Map;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Enumeration of the display mode of the google calendar
 *
 */
public class ModeEnumerator implements Enumerator<String>
{
    private static final String __CATALOGUE = "plugin.google-calendar";
    private static final Map<String, I18nizableText> __MODES;
    
    static
    {
        __MODES = new LinkedHashMap<>(3);
        __MODES.put("AGENDA", new I18nizableText(__CATALOGUE, "PLUGINS_GOOGLE_CALENDAR_SERVICE_CALENDAR_MODE_AGENDA"));
        __MODES.put("MONTH", new I18nizableText(__CATALOGUE, "PLUGINS_GOOGLE_CALENDAR_SERVICE_CALENDAR_MODE_DEFAULT"));
        __MODES.put("WEEK", new I18nizableText(__CATALOGUE, "PLUGINS_GOOGLE_CALENDAR_SERVICE_CALENDAR_MODE_WEEK"));
    }
    
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        return __MODES;
    }

    public I18nizableText getEntry(String value) throws Exception
    {
        return __MODES.get(value);
    }
}
