/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.joboffer;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.ContentVersionHistoryHelper;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.DateExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobExecutionContext;

public class CleanExpiredApplicationSchedulable
extends AbstractStaticSchedulable {
    protected ContentDAO _contentDAO;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected AmetysObjectResolver _resolver;
    protected ContentVersionHistoryHelper _versionHistoryHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentDAO = (ContentDAO)manager.lookup(ContentDAO.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._versionHistoryHelper = (ContentVersionHistoryHelper)manager.lookup(ContentVersionHistoryHelper.ROLE);
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        Long delay = (Long)context.getMergedJobDataMap().get((Object)"parameterValues#delay");
        if (delay == null) {
            delay = (Long)Config.getInstance().getValue("job-offer.clean-expired-application.delay", false, null);
        }
        if (delay == null || delay < 0L) {
            throw new IllegalArgumentException("The expiration delay must be positive");
        }
        ZonedDateTime expirationDateTime = ZonedDateTime.now().minus(Period.ofMonths(delay.intValue()));
        Date expirationDate = DateUtils.asDate((ZonedDateTime)expirationDateTime);
        DateExpression dateExpression = new DateExpression("lastModified", Expression.Operator.LE, expirationDate, ExpressionContext.newInstance().withInternal(true));
        ContentTypeExpression contentTypeExpression = this._cTypeEP.createHierarchicalCTExpression(new String[]{"org.ametys.plugins.job-offer.Content.jobApplication"});
        AndExpression expiredApplicationExpression = new AndExpression(new Expression[]{contentTypeExpression, dateExpression});
        String query = ContentQueryHelper.getContentXPathQuery((Expression)expiredApplicationExpression);
        try (AmetysObjectIterable applications = this._resolver.query(query);){
            this._contentDAO.forceDeleteContentsObj((Iterable)applications, null);
            ForensicLogger.info((String)"data.policy.gdpr.remove.job-offer.applications", Map.of("handled", Long.toString(applications.getSize())), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
        }
        this._versionHistoryHelper.clearUnusedHistory("org.ametys.plugins.job-offer.Content.jobApplication");
    }
}

