/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.joboffer.action;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.content.FOContentCreationHelper;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplyJobOfferAction
extends ServiceableAction {
    private static final int _INITIAL_ACTION_ID = 1;
    protected AmetysObjectResolver _resolver;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected JSONUtils _jsonUtils;
    protected FOContentCreationHelper _foContentCreationHelper;
    protected PageHelper _pageHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._foContentCreationHelper = (FOContentCreationHelper)serviceManager.lookup(FOContentCreationHelper.ROLE);
        this._pageHelper = (PageHelper)serviceManager.lookup(PageHelper.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map<String, Boolean> result = new HashMap<String, Object>();
        ArrayListMultimap errors = ArrayListMultimap.create();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String zoneId = request.getParameter("zoneId");
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneId);
        SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
        String siteName = request.getParameter("site");
        String language = request.getParameter("lang");
        ContentType contentType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.job-offer.Content.jobApplication");
        String workflowName = (String)contentType.getDefaultWorkflowName().get();
        Map values = this._foContentCreationHelper.getAndValidateFormValues(request, contentType, "main", (Multimap)errors);
        if (this._pageHelper.isCaptchaRequired(sitemapElement)) {
            String captchaValue = request.getParameter("captcha");
            String captchaKey = request.getParameter("captcha-key");
            if (!CaptchaHelper.checkAndInvalidate((String)captchaKey, (String)captchaValue)) {
                errors.put((Object)"captcha", (Object)new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_APPLY_FORM_ERROR_INVALID_CAPTCHA"));
            }
        }
        if (errors.isEmpty()) {
            String title = this.getTitle(request);
            result = this._foContentCreationHelper.createAndEditContent(1, new String[]{"org.ametys.plugins.job-offer.Content.jobApplication"}, ArrayUtils.EMPTY_STRING_ARRAY, siteName, title, title, language, values, workflowName, null, new HashMap());
            if (result.containsKey(Content.class.getName())) {
                result.put("success", true);
            } else {
                result.put("success", false);
            }
        } else {
            result.put("success", false);
            result.put("errors", (Boolean)((Object)this._jsonUtils.convertObjectToJson((Object)errors.asMap())));
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    protected String getTitle(Request request) {
        Object[] array = List.of(request.getParameter("lastname"), request.getParameter("firstname")).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList()).toArray();
        return StringUtils.join((Object[])array, (String)" ");
    }
}

