/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.joboffer.generator;

import java.io.IOException;
import java.time.LocalDate;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.web.WebConstants;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.content.FOContentCreationHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JobApplicationFormGenerator
extends ServiceableGenerator {
    protected ContentTypeExtensionPoint _cTypeExtPt;
    protected FOContentCreationHelper _foContentCreationHelper;
    protected PageHelper _pageHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cTypeExtPt = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._foContentCreationHelper = (FOContentCreationHelper)smanager.lookup(FOContentCreationHelper.ROLE);
        this._pageHelper = (PageHelper)smanager.lookup(PageHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Page page = (Page)request.getAttribute(WebConstants.REQUEST_ATTR_PAGE);
        Content content = (Content)request.getAttribute(Content.class.getName());
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form");
        LocalDate closingDate = (LocalDate)content.getValue("closingDate");
        if (closingDate != null && closingDate.isBefore(LocalDate.now())) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"expired", (String)"true");
        }
        ContentType contentType = (ContentType)this._cTypeExtPt.getExtension("org.ametys.plugins.job-offer.Content.jobApplication");
        contentType.getView("main").toSAX(this.contentHandler, DefinitionContext.newInstance().withItemTagName("metadata"));
        this._foContentCreationHelper.saxContentValues(this.contentHandler, contentType, "items", content.getLanguage());
        if (page != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"has-captcha", (String)String.valueOf(this._pageHelper.isCaptchaRequired((SitemapElement)page)));
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form");
        this.contentHandler.endDocument();
    }
}

