/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.joboffer.observer;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ametys.cms.content.indexing.solr.SolrIndexer;
import org.ametys.cms.indexing.IndexingObserver;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.joboffer.observer.AbstractJobOfferObserver;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ModifiedJobOfferObserver
extends AbstractJobOfferObserver
implements IndexingObserver {
    private SolrIndexer _solrIndexer;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._solrIndexer = (SolrIndexer)smanager.lookup(SolrIndexer.ROLE);
    }

    @Override
    protected Set<String> _getSupportedEventIds() {
        return Set.of("content.modified");
    }

    @Override
    protected void _internalObserver(Event event, Content content, Map<String, Object> transientVars) throws Exception {
        UserIdentity[] oldPersonsInCharge;
        UserIdentity[] personsInCharge = (UserIdentity[])content.getValue("personInCharge");
        if (!Objects.deepEquals(personsInCharge, oldPersonsInCharge = (UserIdentity[])this._getRequest().getAttribute(REQUEST_ATTR_PERSON_IN_CHARGE))) {
            this._reIndexApplications(content);
        }
    }

    private void _reIndexApplications(Content content) throws Exception {
        ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.job-offer.Content.jobApplication"});
        StringExpression jobExpr = new StringExpression("jobOffer", Expression.Operator.EQ, content.getId());
        AndExpression finalExpr = new AndExpression(new Expression[]{cTypeExpr, jobExpr});
        String query = ContentQueryHelper.getContentXPathQuery((Expression)finalExpr);
        AmetysObjectIterable applications = this._resolver.query(query);
        this._solrIndexer.updateAclCache((Iterable)applications);
    }
}

