/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.joboffer.right;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplicationAccessController
extends AbstractRightBasedAccessController
implements Serviceable {
    protected ContentTypesHelper _cTypeHelper;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._cTypeHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    protected List<String> getApplicationRights() {
        return List.of("Workflow_Right_Application_Edit", "Workflow_Right_Application_Shortlist", "Workflow_Right_Application_Disapprove");
    }

    protected boolean isInCharge(UserIdentity user, Content content) {
        Object[] personsInCharge = this.getPersonInCharge(content);
        return personsInCharge != null && ArrayUtils.contains((Object[])personsInCharge, (Object)user);
    }

    protected UserIdentity[] getPersonInCharge(Content content) {
        if (content.hasDefinition("jobOffer/personInCharge")) {
            return (UserIdentity[])content.getValue("jobOffer/personInCharge");
        }
        return null;
    }

    public boolean supports(Object object) {
        return object instanceof Content && this._cTypeHelper.isInstanceOf((Content)object, "org.ametys.plugins.job-offer.Content.jobApplication");
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        if (object instanceof Content && this.isInCharge(user, (Content)object)) {
            return this.getApplicationRights().contains(rightId) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        if (object instanceof Content && this.isInCharge(user, (Content)object)) {
            return AccessController.AccessResult.USER_ALLOWED;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> permissionByRight = new HashMap<String, AccessController.AccessResult>();
        if (this.isInCharge(user, (Content)object)) {
            for (String rightId : this.getApplicationRights()) {
                permissionByRight.put(rightId, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return permissionByRight;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        UserIdentity[] personInCharge;
        HashMap<UserIdentity, AccessController.AccessResult> permissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        if (this.getApplicationRights().contains(rightId) && (personInCharge = this.getPersonInCharge((Content)object)) != null) {
            for (UserIdentity userIdentity : personInCharge) {
                permissionByUser.put(userIdentity, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return permissionByUser;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> readPermissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        UserIdentity[] personInCharge = this.getPersonInCharge((Content)object);
        if (personInCharge != null) {
            for (UserIdentity userIdentity : personInCharge) {
                readPermissionByUser.put(userIdentity, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return readPermissionByUser;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    protected AccessExplanation _getAccessExplanation(AccessController.AccessResult result, Object object, UserIdentity user, Set<GroupIdentity> groups, String rightId) {
        switch (result) {
            case USER_ALLOWED: 
            case UNKNOWN: {
                Content jobApplication = (Content)object;
                ContentValue jobOffer = (ContentValue)jobApplication.getValue("jobOffer");
                return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_APPLICATION_ACCESS_CONTROLLER_" + result.name() + "_EXPLANATION", Map.of("title", new I18nizableText(jobOffer.getContent().getTitle()))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        if (StringUtils.isNotBlank((CharSequence)siteName)) {
            ContentTypeExpression typeExpression = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.job-offer.Content.jobOffer"});
            UserExpression inChargeExpression = new UserExpression("personInCharge", Expression.Operator.EQ, identity, true);
            StringExpression siteExpression = new StringExpression("site", Expression.Operator.EQ, siteName, ExpressionContext.newInstance().withInternal(true));
            String query = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression(new Expression[]{typeExpression, inChargeExpression, siteExpression}));
            try (AmetysObjectIterable offers = this._resolver.query(query);){
                if (offers.getSize() > 0L) {
                    List<Expression> applicationsExpression = offers.stream().map(AmetysObject::getId).map(id -> new StringExpression("jobOffer", Expression.Operator.EQ, id)).toList();
                    String applicationQuery = ContentQueryHelper.getContentXPathQuery((Expression)new AndExpression(new Expression[]{new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.job-offer.Content.jobApplication"}), new OrExpression(applicationsExpression)}));
                    AmetysObjectIterable ametysObjectIterable = this._resolver.query(applicationQuery);
                    return ametysObjectIterable;
                }
            }
        }
        return List.of();
    }

    protected Collection<String> getHandledRights() {
        return this.getApplicationRights();
    }

    public I18nizableText getObjectCategory(Object object) {
        return new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_APPLICATION_ACCESS_CONTROLLER_CONTEXT_CATEGORY");
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Content) {
            Content application = (Content)object;
            ContentValue jobOffer = (ContentValue)application.getValue("jobOffer");
            return new I18nizableText(jobOffer.getContent().getTitle() + " > " + application.getTitle());
        }
        throw new RightsException("Unsupported object: " + object.toString());
    }
}

