/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.joboffer.workflow;

import com.opensymphony.workflow.WorkflowException;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.site.Site;
import org.ametys.web.workflow.SendMailFunction;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;

public class SendMailToPersonInChargeFunction
extends SendMailFunction {
    private RenderingContextHandler _renderingContextHandler;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._renderingContextHandler = (RenderingContextHandler)smanager.lookup(RenderingContextHandler.ROLE);
    }

    protected Set<UserIdentity> _getUsers(WorkflowAwareContent content, Set<String> rights) throws WorkflowException {
        if (content.hasDefinition("jobOffer/personInCharge")) {
            UserIdentity[] personIncharge = (UserIdentity[])content.getValue("jobOffer/personInCharge");
            return personIncharge != null ? Set.of(personIncharge) : Set.of();
        }
        return Set.of();
    }

    protected String getSender(Map transientVars, WorkflowAwareContent content) throws WorkflowException {
        if (content instanceof WebContent) {
            Site site = ((WebContent)content).getSite();
            return (String)site.getValue("site-mail-from", false, (Object)((String)Config.getInstance().getValue("smtp.mail.from")));
        }
        return (String)Config.getInstance().getValue("smtp.mail.from");
    }

    protected List<String> getSubjectI18nParams(User user, WorkflowAwareContent content) {
        ContentValue value = (ContentValue)content.getValue("jobOffer");
        ModifiableContent jobOffer = value.getContent();
        ArrayList<String> i18nParams = new ArrayList<String>();
        i18nParams.add(jobOffer.getTitle());
        i18nParams.add((String)jobOffer.getValue("refId", false, (Object)""));
        return i18nParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StandardMailBodyHelper.MailBodyBuilder getMailBody(String subjectI18nKey, String bodyI18nKey, User user, WorkflowAwareContent content, Map transientVars) {
        StandardMailBodyHelper.MailBodyBuilder mailBodyBuilder;
        Source src = null;
        Request request = this._getRequest();
        String currentWorkspace = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            this._renderingContextHandler.setRenderingContext(RenderingContext.PREVIEW);
            request.setAttribute("_baseServerPath", (Object)this._getRequestUri());
            ContentValue jobOffer = (ContentValue)content.getValue("jobOffer");
            ModifiableContent jobOfferContent = jobOffer.getContent();
            Site site = this._getSite(content);
            String jobApplicationUri = this._getContentUri(content, null, site);
            List<String> i18nParams = List.of(jobOfferContent.getTitle(), (String)jobOfferContent.getValue("refId", false, (Object)""));
            StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(this.getMailSubject(subjectI18nKey, user, content, transientVars)).addMessage(new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_WORKFLOW_MAIL_BODY_INTRO", i18nParams)).addMessage(new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_WORKFLOW_MAIL_BODY_JOB_APPLICATION_LINK", List.of(jobApplicationUri))).addMessage(new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_WORKFLOW_MAIL_BODY_TOOL_LINK", List.of(this._getToolUri(site)))).withLink(jobApplicationUri, new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_WORKFLOW_MAIL_BODY_JOB_APPLICATION_LINK_TITLE"));
            String uri = "cocoon:/apply/mail.html";
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("content", content);
            parameters.put("uriPrefix", this._getRequestUri());
            parameters.put("siteName", this._getSite(content).getName());
            src = this._sourceResolver.resolveURI(uri, null, parameters);
            InputStreamReader reader = new InputStreamReader(src.getInputStream(), "UTF-8");
            String details = IOUtils.toString((Reader)reader);
            bodyBuilder.withDetails(new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_WORKFLOW_MAIL_BODY_JOB_APPLICATION"), details, false);
            mailBodyBuilder = bodyBuilder;
            this._sourceResolver.release(src);
        }
        catch (IOException e) {
            this._logger.warn("Failed to get HTML body for mail notification for new application " + content.getId(), (Throwable)e);
            StandardMailBodyHelper.MailBodyBuilder mailBodyBuilder2 = null;
            return mailBodyBuilder2;
        }
        finally {
            this._sourceResolver.release(src);
            this._renderingContextHandler.setRenderingContext(currentContext);
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWorkspace);
        }
        this._renderingContextHandler.setRenderingContext(currentContext);
        RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWorkspace);
        return mailBodyBuilder;
    }

    protected String _getToolUri(Site site) {
        String siteName = site != null ? site.getName() : WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        return this._getRequestUri() + "/" + siteName + "/index.html?uitool=uitool-application-search,id:%27search-ui.job-applications%27";
    }

    protected void _sendMails(I18nizableText subjectI18nKey, StandardMailBodyHelper.MailBodyBuilder bodyBuilder, Map<String, Set<String>> recipientsByLanguage, String from) throws IOException {
        if (bodyBuilder != null) {
            for (String language : recipientsByLanguage.keySet()) {
                String subject = this._i18nUtils.translate((I18nizable)subjectI18nKey, language);
                String body = bodyBuilder.withLanguage(language).build();
                for (String recipient : recipientsByLanguage.get(language)) {
                    try {
                        SendMailHelper.newMail().withSubject(subject).withHTMLBody(body).withSender(from).withRecipient(recipient).withAsync(true).sendMail();
                    }
                    catch (MessagingException | IOException e) {
                        this._logger.warn("Could not send a workflow notification mail to " + recipient, e);
                    }
                }
            }
        }
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.job-offer", "PLUGINS_JOB_OFFER_SEND_MAIL_TO_PERSON_IN_CHARGE_FUNCTION_LABEL");
    }
}

