<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:escape="org.apache.commons.lang.StringEscapeUtils" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:math="java.lang.Math" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver math ametys escape">

    <xsl:import href="service:web://pages/services/contenttype/helper/form.xsl"/>  
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="job-application-form-get-url">
        <xsl:value-of select="$site-uri-prefix"/>/_plugins/job-offer/apply/submit/<xsl:value-of select="$uniqueId" />
    </xsl:template>
    
    <xsl:template name="job-application-form-js">
        <xsl:call-template name="contenttype-form-header">
            <xsl:with-param name="view" select="/view/form/view"/>
        </xsl:call-template>
    </xsl:template>
    
    
    <xsl:template name="job-application-form">
        <xsl:choose>
            <xsl:when test="/view/form/expired = 'true'">
                <xsl:call-template name="application-expired"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="job-application-form-form"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="application-expired">
        <div class="apply-form-expired">
            <i18n:text i18n:key="PLUGINS_JOB_OFFER_APPLY_FORM_EXPIRED" i18n:catalogue="plugin.job-offer"/>
        </div>
    </xsl:template>
    
    <xsl:template name="job-application-form-form">
        <div class="apply-form">
            <xsl:call-template name="job-application-form-header"/>

            <xsl:call-template name="job-application-form-hints" />
            
            <xsl:variable name="job-application-form-url"><xsl:call-template name="job-application-form-get-url"/></xsl:variable>
            
            <xsl:call-template name="contenttype-form">
                <xsl:with-param name="className">job-application-form</xsl:with-param>
                <xsl:with-param name="actionUrl" select="$job-application-form-url"/>
                <xsl:with-param name="submitJsClass" select="concat('apply_job_', $uniqueId, '()')"/>
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
                <xsl:with-param name="formId" select="concat('job-application-form-', $uniqueId)"/>
                <xsl:with-param name="view" select="/view/form/view"/>
                <xsl:with-param name="submitI18nKey" select="'plugin.job-offer:PLUGINS_JOB_OFFER_APPLY_FORM_SUBMIT'"></xsl:with-param>
                <xsl:with-param name="contentValues" select="/view/form/items"></xsl:with-param>
                <xsl:with-param name="withCaptcha" select="/view/form/has-captcha = 'true'"/>
            </xsl:call-template>
            
            <script type="text/javascript">
                $j(document).ready(function() {
                    var $form = $j("#job-application-form-<xsl:value-of select="$uniqueId" />");
                    
                    var _getAmetysUserCb = function(user)
                    {
                        if (user)
                        {
                            $form.find('input[name="lastname"]').val(user.lastname);
                            $form.find('input[name="firstname"]').val(user.firstname);
                            $form.find('input[name="email"]').val(user.email);
                        }
                    }
                    
                    getAmetysUser(_getAmetysUserCb);
                    
                    var $jobInput = $form.find('*[name="jobOffer"]');
                    if ($jobInput.length == 0)
                    {
                        console.error("No input for job offer (jobOffer)");
                    }
                    else
                    {
                        $jobInput.val("<xsl:value-of select="/view/content/@id"/>");
                        $jobInput.hide();
                    }
                });
            </script>
            
            <xsl:call-template name="job-application-form-script"/>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata[@name='jobOffer']" mode="contenttype-form-field">
        <input type="hidden" name="jobOffer" value="/view/content/@id"/>
    </xsl:template>
    
    <xsl:template name="job-application-form-header">
        <h2><i18n:text i18n:key="PLUGINS_JOB_OFFER_APPLY_FORM_TITLE" i18n:catalogue="plugin.job-offer"/></h2>
    </xsl:template>
    
    <xsl:template name="job-application-form-redirect-page"/>
    
    <xsl:template name="job-application-form-script">
        <xsl:variable name="redirect-page"><xsl:call-template name="job-application-form-redirect-page"/></xsl:variable>
        <xsl:variable name="href">
            <xsl:choose>
                <xsl:when test="$redirect-page != ''"><xsl:value-of select="$redirect-page"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$site-uri-prefix"/>/<xsl:value-of select="$lang"/>/_plugins/job-offer/page/apply/results.html</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
            
        <script type="text/javascript">    
            function apply_job_<xsl:value-of select="$uniqueId" />()
            {
                var iframe = $j("#iframe-<xsl:value-of select="$uniqueId" />");
                if (iframe.length == 0)
                {
                    iframe = $j('&lt;iframe name="iframe-<xsl:value-of select="$uniqueId" />" frameborder="0" scrolling="no" id="iframe-<xsl:value-of select="$uniqueId" />"&gt;&lt;/iframe&gt;').appendTo('body');
                    iframe.on('load', function() {
                        var doc = this.contentWindow.document;
                        if (doc.title != 'Ametys-result')
                        {
                            alert("<i18n:text i18n:key="PLUGINS_JOB_OFFER_APPLY_FORM_ERROR_DESCRIPTION" i18n:catalogue="plugin.job-offer"/>");                
                        }
                    });
                }

                var form = $j("#job-application-form-<xsl:value-of select="$uniqueId" />");
                form.prop('target', 'iframe-<xsl:value-of select="$uniqueId" />');
                form.submit(function( event ) {
                    return true;
                });
                
                return false;
            }
            
            function result_<xsl:value-of select="$uniqueId" />(success, errors)
            {
                $j('div.error').each(function () 
                {
                    var div = $j(this);
                    div.removeClass("error");
                });
                    
                $j('span.error').each(function () 
                {
                    $j(this).remove();
                });
                
                if (success)
                {
                    window.location = "<xsl:value-of select="$href" />";
                }
                else
                {
                    $j.each(errors, function(metadataNameForm)
                    {
                        var error = $j(this);
                        var re = new RegExp('[.]', 'g');
                        var escapeMetadataNameForm = metadataNameForm.replace(re, '\\.');
        
                        var errorText = errors[metadataNameForm][0];
                        
                        var input = $j('#input-' + escapeMetadataNameForm + '-<xsl:value-of select="$uniqueId" />');
                        input.append("&lt;span class='error' id='error-" + metadataNameForm + "-<xsl:value-of select="$uniqueId" />" + "' &gt;" + errorText + "&lt;/span&gt;");
                
                        var field = $j('#field-' + escapeMetadataNameForm + '-<xsl:value-of select="$uniqueId" />' + ' .label');
                        field.addClass("error");
                    });
                }
            }
        </script>
    </xsl:template> 
    
    <xsl:template name="job-application-form-hints">
        <xsl:param name="formId" select="concat('job-application-form-', $uniqueId)"/>
        
        <p class="form-hint" style="display: none">
            <span class="mandatory-hint"><i18n:text i18n:key="PLUGINS_JOB_OFFER_APPLY_FORM_MANDATORY_HINT" i18n:catalogue="plugin.job-offer"/></span>
        </p>
        <script>
            $j(document).ready(function(){
                var $form = $j('#<xsl:value-of select="$formId"/>');
                if ($form.find('[data-ametys-mandatory]').length)
                {
                    $form.parent().find('.form-hint').show();
                }
            });
        </script>
    </xsl:template>
</xsl:stylesheet>
