<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:param name="uri-prefix"/>
    <xsl:param name="siteName"/>
    
    <xsl:template match="/mail">
        <body>
            <xsl:apply-templates select="view/metadata" mode="display"/>
        </body>
    </xsl:template>
    
    <xsl:template name="breakline"><xsl:text>&lt;br/&gt;</xsl:text></xsl:template>
    
    <xsl:template match="metadata[@type='composite']" mode="display">
        <xsl:param name="name" select="@name"/>
        &lt;strong&gt;<xsl:value-of select="label"/>&lt;/strong&gt;
        <xsl:apply-templates select="metadata" mode="display"/>
        <xsl:call-template name="breakline"/>
    </xsl:template>
    
    <xsl:template match="metadata" mode="display">
        <xsl:param name="path" select="@path"/>
        <xsl:param name="value" select="/mail/content/attributes//*[@dataPath = $path]"/>
        
        <xsl:if test="$value">
            <xsl:apply-templates select="." mode="display-label"/>
            
            <xsl:apply-templates select="." mode="display-value">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
        <xsl:call-template name="breakline"/>
    </xsl:template>
    
    <xsl:template match="metadata" mode="display-label">
        <xsl:text>&lt;strong&gt;</xsl:text><xsl:value-of select="label"/><xsl:text>&lt;/strong&gt;</xsl:text>
        <xsl:call-template name="breakline"/>
    </xsl:template>
    
    <xsl:template match="metadata" mode="display-value">
        <xsl:param name="value"/>
        
        <xsl:variable name="definition" select="."/>
        <xsl:for-each select="$value">
            <xsl:apply-templates select="$definition" mode="value">
                <xsl:with-param name="value" select="."/>
            </xsl:apply-templates>
            <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    </xsl:template>
    
     <xsl:template match="metadata[@type='content']" mode="value">
        <xsl:param name="value"/>
        <xsl:value-of select="$value/@title"/>
    </xsl:template>
    
    <xsl:template match="metadata[@type='boolean']" mode="value">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'"><i18n:text i18n:key="CONTENT_VIEW_TRUE_LABEL" i18n:catalogue="plugin.cms"/></xsl:when>
            <xsl:otherwise><i18n:text i18n:key="CONTENT_VIEW_FALSE_LABEL" i18n:catalogue="plugin.cms"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="metadata[@type='date' or @type='datetime']" mode="value">
        <xsl:param name="value"/>
        <i18n:date pattern="medium" src-pattern="yyyy-MM-dd'T'HH:mm" value="{$value}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@type='file']" mode="value">
        <xsl:param name="value"/>
        <xsl:text></xsl:text>&lt;a href="<xsl:value-of select="resolver:resolve('joboffer-attribute', $value/@uri, true(), true())"/>" title="<xsl:value-of select="$value/@filename"/>"&gt;<xsl:value-of select="$value/@filename"/>&lt;/a&gt;<xsl:text></xsl:text>
    </xsl:template>
        
    <xsl:template match="metadata" mode="value">
        <xsl:param name="value"/>
        <xsl:value-of select="$value"/>
    </xsl:template>
    
</xsl:stylesheet>
