/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.joboffer;

/**
 * Job offer constant
 *
 */
public interface JobOfferConstants
{
    /** Id of the application content type */
    public static final String JOB_APPLICATION_CONTENT_TYPE = "org.ametys.plugins.job-offer.Content.jobApplication";
    
    /** Id of the application job offer */
    public static final String JOB_OFFER_CONTENT_TYPE = "org.ametys.plugins.job-offer.Content.jobOffer";
    
    /** Path of attribute holding the persons in charge */
    public static String JOB_OFFER_ATTRIBUTE_PATH_PERSON_IN_CHARGE = "personInCharge";
    
    /** Path of attribute holding the persons in charge */
    public static String JOB_OFFER_ATTRIBUTE_PATH_CLOSING_DATE = "closingDate";
    
    /** Path of attribute holding the persons in charge */
    public static String JOB_OFFER_ATTRIBUTE_PATH_APPLICATIONS = "applications";
    
    /** Path of attribute holding the job id */
    public static String JOB_OFFER_ATTRIBUTE_PATH_REF_ID = "refId";
    
    /** Path of attribute holding the job offer */
    public static String JOB_APPLICATION_ATTRIBUTE_PATH_JOB_OFFER = "jobOffer";
    
    /** Path of attribute holding the the persons in charge */
    public static String JOB_APPLICATION_ATTRIBUTE_PATH_PERSON_IN_CHARGE = "jobOffer/personInCharge";
}
